/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.MappingContext;
import org.springframework.binding.mapping.RequiredMappingException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class Mapping
implements AttributeMapper,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$binding$mapping$Mapping == null ? (class$org$springframework$binding$mapping$Mapping = Mapping.class$("org.springframework.binding.mapping.Mapping")) : class$org$springframework$binding$mapping$Mapping));
    private final Expression sourceExpression;
    private final SettableExpression targetExpression;
    private final ConversionExecutor typeConverter;
    private boolean required;
    static /* synthetic */ Class class$org$springframework$binding$mapping$Mapping;

    public Mapping(Expression sourceExpression, SettableExpression targetExpression, ConversionExecutor typeConverter) {
        this(sourceExpression, targetExpression, typeConverter, false);
    }

    protected Mapping(Expression sourceExpression, SettableExpression targetExpression, ConversionExecutor typeConverter, boolean required) {
        Assert.notNull((Object)sourceExpression, (String)"The source expression is required");
        Assert.notNull((Object)targetExpression, (String)"The target expression is required");
        this.sourceExpression = sourceExpression;
        this.targetExpression = targetExpression;
        this.typeConverter = typeConverter;
        this.required = required;
    }

    public void map(Object source, Object target, MappingContext context) {
        Object sourceValue = this.sourceExpression.evaluate(source, null);
        if (sourceValue == null) {
            if (this.required) {
                throw new RequiredMappingException("This mapping is required; evaluation of expression '" + this.sourceExpression + "' against source of type [" + source.getClass() + "] must return a non-null value");
            }
            return;
        }
        Object targetValue = sourceValue;
        if (this.typeConverter != null) {
            targetValue = this.typeConverter.execute(sourceValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping '" + this.sourceExpression + "' value [" + sourceValue + "] to target property '" + this.targetExpression + "'; setting property value to [" + targetValue + "]"));
        }
        this.targetExpression.evaluateToSet(target, targetValue, null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)o;
        return this.sourceExpression.equals(other.sourceExpression) && this.targetExpression.equals(other.targetExpression);
    }

    public int hashCode() {
        return this.sourceExpression.hashCode() + this.targetExpression.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append((Object)(this.sourceExpression + " -> " + this.targetExpression)).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

