/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.MessageCodesResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBinder
implements PropertyEditorRegistry,
TypeConverter {
    public static final String DEFAULT_OBJECT_NAME = "target";
    protected static final Log logger = LogFactory.getLog(DataBinder.class);
    private final Object target;
    private final String objectName;
    private AbstractPropertyBindingResult bindingResult;
    private SimpleTypeConverter typeConverter;
    private BindException bindException;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private String[] allowedFields;
    private String[] disallowedFields;
    private String[] requiredFields;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();

    public DataBinder(Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(Object target, String objectName) {
        this.target = target;
        this.objectName = objectName;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void initBeanPropertyAccess() {
        Assert.isNull((Object)this.bindingResult, (String)"DataBinder is already initialized - call initBeanPropertyAccess before any other configuration methods");
        this.bindingResult = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName());
    }

    public void initDirectFieldAccess() {
        Assert.isNull((Object)this.bindingResult, (String)"DataBinder is already initialized - call initDirectFieldAccess before any other configuration methods");
        this.bindingResult = new DirectFieldBindingResult(this.getTarget(), this.getObjectName());
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    protected SimpleTypeConverter getSimpleTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new SimpleTypeConverter();
        }
        return this.typeConverter;
    }

    protected PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    protected TypeConverter getTypeConverter() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    @Deprecated
    public BindException getErrors() {
        if (this.bindException == null) {
            this.bindException = new BindException(this.getBindingResult());
        }
        return this.bindException;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String[] allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])allowedFields);
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String[] disallowedFields) {
        this.disallowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])disallowedFields);
    }

    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String[] requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString((Object[])requiredFields) + "]"));
        }
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.getPropertyAccessor().setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.getInternalBindingResult().setMessageCodesResolver(messageCodesResolver);
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String field, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        return this.getPropertyEditorRegistry().findCustomEditor(requiredType, propertyPath);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, methodParam);
    }

    public void bind(PropertyValues pvs) {
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (MutablePropertyValues)pvs : new MutablePropertyValues(pvs);
        this.doBind(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkAllowedFields(mpvs);
        this.checkRequiredFields(mpvs);
        this.applyPropertyValues(mpvs);
    }

    protected void checkAllowedFields(MutablePropertyValues mpvs) {
        PropertyValue[] pvs;
        PropertyValue[] propertyValueArray = pvs = mpvs.getPropertyValues();
        int n = pvs.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValue pv = propertyValueArray[n2];
            String field = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
            if (!this.isAllowed(field)) {
                mpvs.removePropertyValue(pv);
                this.getBindingResult().recordSuppressedField(field);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Field [" + field + "] has been removed from PropertyValues " + "and will not be bound, because it has not been found in the list of allowed fields"));
                }
            }
            ++n2;
        }
    }

    protected boolean isAllowed(String field) {
        Object[] allowed = this.getAllowedFields();
        Object[] disallowed = this.getDisallowedFields();
        return !(!ObjectUtils.isEmpty((Object[])allowed) && !PatternMatchUtils.simpleMatch((String[])allowed, (String)field) || !ObjectUtils.isEmpty((Object[])disallowed) && PatternMatchUtils.simpleMatch((String[])disallowed, (String)field));
    }

    protected void checkRequiredFields(MutablePropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (!ObjectUtils.isEmpty((Object[])requiredFields)) {
            PropertyValue[] pvs;
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            Object[] objectArray = pvs = mpvs.getPropertyValues();
            int n = pvs.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv = objectArray[n2];
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
                propertyValues.put(canonicalName, pv);
                ++n2;
            }
            objectArray = requiredFields;
            n = requiredFields.length;
            n2 = 0;
            while (n2 < n) {
                PropertyValue field = objectArray[n2];
                PropertyValue pv = (PropertyValue)propertyValues.get(field);
                if (pv == null || pv.getValue() == null || pv.getValue() instanceof String && !StringUtils.hasText((String)((String)pv.getValue()))) {
                    this.getBindingErrorProcessor().processMissingFieldError((String)field, this.getInternalBindingResult());
                    if (pv != null) {
                        mpvs.removePropertyValue(pv);
                        propertyValues.remove(field);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void applyPropertyValues(MutablePropertyValues mpvs) {
        block3: {
            try {
                this.getPropertyAccessor().setPropertyValues((PropertyValues)mpvs, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
                break block3;
            }
            catch (PropertyBatchUpdateException ex) {
                var6_3 = ex.getPropertyAccessExceptions();
                var5_4 = var6_3.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                pae = var6_3[var4_5];
                this.getBindingErrorProcessor().processPropertyAccessException(pae, this.getInternalBindingResult());
                ++var4_5;
                continue;
            }
        }
    }

    public Map close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }
}

