/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigApplicationContext
extends GenericApplicationContext {
    private final AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(this);
    private final ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this);

    public AnnotationConfigApplicationContext() {
        this.delegateEnvironment(super.getEnvironment());
    }

    public AnnotationConfigApplicationContext(Class<?> ... annotatedClasses) {
        this();
        this.register(annotatedClasses);
        this.refresh();
    }

    public AnnotationConfigApplicationContext(String ... basePackages) {
        this();
        this.scan(basePackages);
        this.refresh();
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.delegateEnvironment(environment);
    }

    private void delegateEnvironment(ConfigurableEnvironment environment) {
        this.reader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
    }

    public void register(Class<?> ... annotatedClasses) {
        this.reader.register(annotatedClasses);
    }

    public void scan(String ... basePackages) {
        this.scanner.scan(basePackages);
    }
}

