/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Map;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanSpec;
import org.springframework.context.annotation.FeatureAnnotationParser;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class ComponentScanAnnotationParser
implements FeatureAnnotationParser {
    ComponentScanAnnotationParser() {
    }

    public ComponentScanSpec process(AnnotationMetadata metadata) {
        ComponentScan.Filter filter;
        String scopedProxyAttribute;
        ScopedProxyMode scopedProxyMode;
        String pkg;
        Map attribs = metadata.getAnnotationAttributes(ComponentScan.class.getName(), true);
        Assert.notNull((Object)attribs, (String)String.format("@ComponentScan annotation not found while parsing metadata for class [%s].", metadata.getClassName()));
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        ComponentScanSpec spec = new ComponentScanSpec();
        String[] stringArray = (String[])attribs.get("value");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            pkg = stringArray[n2];
            spec.addBasePackage(pkg);
            ++n2;
        }
        stringArray = (String[])attribs.get("basePackages");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            pkg = stringArray[n2];
            spec.addBasePackage(pkg);
            ++n2;
        }
        stringArray = (String[])attribs.get("basePackageClasses");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            spec.addBasePackage(className.substring(0, className.lastIndexOf(46)));
            ++n2;
        }
        String resolverAttribute = "scopeResolver";
        if (!((String)attribs.get(resolverAttribute)).equals(((Class)AnnotationUtils.getDefaultValue(ComponentScan.class, (String)resolverAttribute)).getName())) {
            spec.scopeMetadataResolver((String)attribs.get(resolverAttribute), classLoader);
        }
        if ((scopedProxyMode = (ScopedProxyMode)((Object)attribs.get(scopedProxyAttribute = "scopedProxy"))) != (ScopedProxyMode)((Object)AnnotationUtils.getDefaultValue(ComponentScan.class, (String)scopedProxyAttribute))) {
            spec.scopedProxyMode(scopedProxyMode);
        }
        ComponentScan.Filter[] filterArray = (ComponentScan.Filter[])attribs.get("includeFilters");
        int n3 = filterArray.length;
        int n4 = 0;
        while (n4 < n3) {
            filter = filterArray[n4];
            spec.addIncludeFilter(filter.type().toString(), filter.value().getName(), classLoader);
            ++n4;
        }
        filterArray = (ComponentScan.Filter[])attribs.get("excludeFilters");
        n3 = filterArray.length;
        n4 = 0;
        while (n4 < n3) {
            filter = filterArray[n4];
            spec.addExcludeFilter(filter.type().toString(), filter.value().getName(), classLoader);
            ++n4;
        }
        spec.resourcePattern((String)attribs.get("resourcePattern")).useDefaultFilters((Boolean)attribs.get("useDefaultFilters")).beanNameGenerator((String)attribs.get("nameGenerator"), classLoader).source(metadata.getClassName()).sourceName(metadata.getClassName());
        return spec;
    }
}

