/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;

abstract class ConfigurationClassUtils {
    private static final Log logger = LogFactory.getLog(ConfigurationClassUtils.class);
    private static final String CONFIGURATION_CLASS_FULL = "full";
    private static final String CONFIGURATION_CLASS_LITE = "lite";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");

    ConfigurationClassUtils() {
    }

    public static boolean checkConfigurationClassCandidate(BeanDefinition beanDef, MetadataReaderFactory metadataReaderFactory) {
        StandardAnnotationMetadata metadata = null;
        if (beanDef instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)beanDef).hasBeanClass()) {
            metadata = new StandardAnnotationMetadata(((AbstractBeanDefinition)beanDef).getBeanClass());
        } else {
            String className = beanDef.getBeanClassName();
            if (className != null) {
                try {
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(className);
                    metadata = metadataReader.getAnnotationMetadata();
                }
                catch (IOException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Could not find class file for introspecting factory methods: " + className), (Throwable)ex);
                    }
                    return false;
                }
            }
        }
        if (metadata != null) {
            if (ConfigurationClassUtils.isFullConfigurationCandidate(metadata)) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_FULL);
                return true;
            }
            if (ConfigurationClassUtils.isLiteConfigurationCandidate((AnnotationMetadata)metadata)) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_LITE);
                return true;
            }
        }
        return false;
    }

    public static boolean isConfigurationCandidate(AnnotationMetadata metadata) {
        return ConfigurationClassUtils.isFullConfigurationCandidate(metadata) || ConfigurationClassUtils.isLiteConfigurationCandidate(metadata);
    }

    public static boolean isFullConfigurationCandidate(AnnotationMetadata metadata) {
        return metadata.isAnnotated(Configuration.class.getName());
    }

    public static boolean isLiteConfigurationCandidate(AnnotationMetadata metadata) {
        return metadata.isAnnotated(Component.class.getName()) || metadata.hasAnnotatedMethods(Bean.class.getName());
    }

    public static boolean isFullConfigurationClass(BeanDefinition beanDef) {
        return CONFIGURATION_CLASS_FULL.equals(beanDef.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE));
    }
}

