/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.config.AbstractPropertyLoadingBeanDefinitionParser;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyPlaceholderBeanDefinitionParser
extends AbstractPropertyLoadingBeanDefinitionParser {
    PropertyPlaceholderBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        if (element.hasAttribute("system-properties-mode")) {
            return PropertyPlaceholderConfigurer.class;
        }
        return PropertySourcesPlaceholderConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreUnresolvablePlaceholders", (Object)Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String systemPropertiesModeName = element.getAttribute("system-properties-mode");
        if (StringUtils.hasLength((String)systemPropertiesModeName)) {
            builder.addPropertyValue("systemPropertiesModeName", (Object)("SYSTEM_PROPERTIES_MODE_" + systemPropertiesModeName));
        }
    }
}

