/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private ApplicationContext applicationContext;
    private ScheduledTaskRegistrar registrar;
    private final Map<Runnable, String> cronTasks = new HashMap<Runnable, String>();
    private final Map<Runnable, Long> fixedDelayTasks = new HashMap<Runnable, Long>();
    private final Map<Runnable, Long> fixedRateTasks = new HashMap<Runnable, Long>();

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Scheduled annotation = (Scheduled)AnnotationUtils.getAnnotation((Method)method, Scheduled.class);
                if (annotation != null) {
                    long fixedRate;
                    long fixedDelay;
                    Assert.isTrue((boolean)Void.TYPE.equals(method.getReturnType()), (String)"Only void-returning methods may be annotated with @Scheduled.");
                    Assert.isTrue((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled.");
                    ScheduledMethodRunnable runnable = new ScheduledMethodRunnable(bean, method);
                    boolean processedSchedule = false;
                    String errorMessage = "Exactly one of 'cron', 'fixedDelay', or 'fixedRate' is required.";
                    String cron = annotation.cron();
                    if (!"".equals(cron)) {
                        processedSchedule = true;
                        if (ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver != null) {
                            cron = ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(cron);
                        }
                        ScheduledAnnotationBeanPostProcessor.this.cronTasks.put(runnable, cron);
                    }
                    if ((fixedDelay = annotation.fixedDelay()) >= 0L) {
                        Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedDelayTasks.put(runnable, fixedDelay);
                    }
                    if ((fixedRate = annotation.fixedRate()) >= 0L) {
                        Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedRateTasks.put(runnable, fixedRate);
                    }
                    Assert.isTrue((boolean)processedSchedule, (String)errorMessage);
                }
            }
        });
        return bean;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() != this.applicationContext) {
            return;
        }
        Map configurers = this.applicationContext.getBeansOfType(SchedulingConfigurer.class);
        if (this.cronTasks.isEmpty() && this.fixedDelayTasks.isEmpty() && this.fixedRateTasks.isEmpty() && configurers.isEmpty()) {
            return;
        }
        this.registrar = new ScheduledTaskRegistrar();
        this.registrar.setCronTasks(this.cronTasks);
        this.registrar.setFixedDelayTasks(this.fixedDelayTasks);
        this.registrar.setFixedRateTasks(this.fixedRateTasks);
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        for (SchedulingConfigurer configurer : configurers.values()) {
            configurer.configureTasks(this.registrar);
        }
        if (this.registrar.getScheduler() == null) {
            HashMap schedulers = new HashMap();
            schedulers.putAll(this.applicationContext.getBeansOfType(TaskScheduler.class));
            schedulers.putAll(this.applicationContext.getBeansOfType(ScheduledExecutorService.class));
            if (schedulers.size() != 0) {
                if (schedulers.size() == 1) {
                    this.registrar.setScheduler(schedulers.values().iterator().next());
                } else if (schedulers.size() >= 2) {
                    throw new IllegalStateException("More than one TaskScheduler and/or ScheduledExecutorService  exist within the context. Remove all but one of the beans; or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback. Found the following beans: " + schedulers.keySet());
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        if (this.registrar != null) {
            this.registrar.destroy();
        }
    }
}

