/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeFormatterFactory
implements FactoryBean<DateTimeFormatter> {
    private DateTimeFormat.ISO iso;
    private String style;
    private String pattern;
    private TimeZone timeZone;

    public DateTimeFormatterFactory() {
    }

    public DateTimeFormatterFactory(String pattern) {
        this.pattern = pattern;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return DateTimeFormatter.class;
    }

    public DateTimeFormatter getObject() throws Exception {
        return this.getDateTimeFormatter();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.getDateTimeFormatter(DateTimeFormat.mediumDateTime());
    }

    public DateTimeFormatter getDateTimeFormatter(DateTimeFormatter fallbackFormatter) {
        DateTimeFormatter dateTimeFormatter = this.createDateTimeFormatter();
        if (dateTimeFormatter != null && this.timeZone != null) {
            dateTimeFormatter.withZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        }
        return dateTimeFormatter != null ? dateTimeFormatter : fallbackFormatter;
    }

    private DateTimeFormatter createDateTimeFormatter() {
        if (StringUtils.hasLength((String)this.pattern)) {
            return DateTimeFormat.forPattern((String)this.pattern);
        }
        if (this.iso != null && this.iso != DateTimeFormat.ISO.NONE) {
            if (this.iso == DateTimeFormat.ISO.DATE) {
                return ISODateTimeFormat.date();
            }
            if (this.iso == DateTimeFormat.ISO.TIME) {
                return ISODateTimeFormat.time();
            }
            return ISODateTimeFormat.dateTime();
        }
        if (StringUtils.hasLength((String)this.style)) {
            return DateTimeFormat.forStyle((String)this.style);
        }
        return null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setIso(DateTimeFormat.ISO iso) {
        this.iso = iso;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

