/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ResourceScriptSource
implements ScriptSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Resource resource;
    private long lastModified = -1L;
    private final Object lastModifiedMonitor = new Object();
    private String encoding = "UTF-8";

    public ResourceScriptSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.resource = resource;
    }

    public final Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScriptAsString() throws IOException {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            this.lastModified = this.retrieveLastModifiedTime();
        }
        InputStream stream = this.resource.getInputStream();
        InputStreamReader reader = StringUtils.hasText((String)this.encoding) ? new InputStreamReader(stream, this.encoding) : new InputStreamReader(stream);
        return FileCopyUtils.copyToString((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            return this.lastModified < 0L || this.retrieveLastModifiedTime() > this.lastModified;
        }
    }

    protected long retrieveLastModifiedTime() {
        try {
            return this.getResource().lastModified();
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getResource() + " could not be resolved in the file system - " + "current timestamp not available for script modification check"), (Throwable)ex);
            }
            return 0L;
        }
    }

    @Override
    public String suggestedClassName() {
        return StringUtils.stripFilenameExtension((String)this.getResource().getFilename());
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        return this.resource.toString();
    }
}

