/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.util.ArrayList;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.annotation.ProxyCachingConfiguration;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.util.ClassUtils;

public class CachingConfigurationSelector
extends AdviceModeImportSelector<EnableCaching> {
    private static final String PROXY_JCACHE_CONFIGURATION_CLASS = "org.springframework.cache.jcache.config.ProxyJCacheConfiguration";
    private static final boolean jsr107Present = ClassUtils.isPresent((String)"javax.cache.Cache", (ClassLoader)CachingConfigurationSelector.class.getClassLoader());
    private static final boolean jCacheImplPresent = ClassUtils.isPresent((String)"org.springframework.cache.jcache.config.ProxyJCacheConfiguration", (ClassLoader)CachingConfigurationSelector.class.getClassLoader());

    @Override
    public String[] selectImports(AdviceMode adviceMode) {
        switch (adviceMode) {
            case PROXY: {
                return this.getProxyImports();
            }
            case ASPECTJ: {
                return this.getAspectJImports();
            }
        }
        return null;
    }

    private String[] getProxyImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(AutoProxyRegistrar.class.getName());
        result.add(ProxyCachingConfiguration.class.getName());
        if (this.isJCacheAvailable()) {
            result.add(PROXY_JCACHE_CONFIGURATION_CLASS);
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getAspectJImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("org.springframework.cache.aspectj.AspectJCachingConfiguration");
        if (this.isJCacheAvailable()) {
            result.add("org.springframework.cache.aspectj.AspectJJCacheConfiguration");
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean isJCacheAvailable() {
        return jsr107Present && jCacheImplPresent;
    }
}

