/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.util.Assert;

public abstract class BaseCacheResolver
implements CacheResolver,
InitializingBean {
    private CacheManager cacheManager;

    protected BaseCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected BaseCacheResolver() {
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cacheManager, (String)"CacheManager must not be null");
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = this.getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>();
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Assert.notNull((Object)cache, (String)("Cannot find cache named '" + cacheName + "' for " + context.getOperation()));
            result.add(cache);
        }
        return result;
    }

    protected abstract Collection<String> getCacheNames(CacheOperationInvocationContext<?> var1);
}

