/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.interceptor.BasicCacheOperation;
import org.springframework.util.Assert;

public abstract class CacheOperation
implements BasicCacheOperation {
    private Set<String> cacheNames = Collections.emptySet();
    private String condition = "";
    private String key = "";
    private String keyGenerator = "";
    private String cacheManager = "";
    private String cacheResolver = "";
    private String name = "";

    @Override
    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyGenerator() {
        return this.keyGenerator;
    }

    public String getCacheManager() {
        return this.cacheManager;
    }

    public String getCacheResolver() {
        return this.cacheResolver;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheName(String cacheName) {
        Assert.hasText((String)cacheName);
        this.cacheNames = Collections.singleton(cacheName);
    }

    public void setCacheNames(String[] cacheNames) {
        this.cacheNames = new LinkedHashSet<String>(cacheNames.length);
        for (String cacheName : cacheNames) {
            Assert.hasText((String)cacheName, (String)"Cache name must be set if specified.");
            this.cacheNames.add(cacheName);
        }
    }

    public void setCondition(String condition) {
        Assert.notNull((Object)condition);
        this.condition = condition;
    }

    public void setKey(String key) {
        Assert.notNull((Object)key);
        this.key = key;
    }

    public void setKeyGenerator(String keyGenerator) {
        Assert.notNull((Object)keyGenerator);
        this.keyGenerator = keyGenerator;
    }

    public void setCacheManager(String cacheManager) {
        Assert.notNull((Object)cacheManager);
        this.cacheManager = cacheManager;
    }

    public void setCacheResolver(String cacheResolver) {
        Assert.notNull((Object)this.cacheManager);
        this.cacheResolver = cacheResolver;
    }

    public void setName(String name) {
        Assert.hasText((String)name);
        this.name = name;
    }

    public boolean equals(Object other) {
        return other instanceof CacheOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getOperationDescription().toString();
    }

    protected StringBuilder getOperationDescription() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("[");
        result.append(this.name);
        result.append("] caches=");
        result.append(this.cacheNames);
        result.append(" | key='");
        result.append(this.key);
        result.append("' | keyGenerator='");
        result.append(this.keyGenerator);
        result.append("' | cacheManager='");
        result.append(this.cacheManager);
        result.append("' | cacheResolver='");
        result.append(this.cacheResolver);
        result.append("' | condition='");
        result.append(this.condition);
        result.append("'");
        return result;
    }
}

