/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormatterPropertyEditorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;

public class DataBinder
implements PropertyEditorRegistry,
TypeConverter {
    public static final String DEFAULT_OBJECT_NAME = "target";
    public static final int DEFAULT_AUTO_GROW_COLLECTION_LIMIT = 256;
    protected static final Log logger = LogFactory.getLog(DataBinder.class);
    private final Object target;
    private final String objectName;
    private AbstractPropertyBindingResult bindingResult;
    private SimpleTypeConverter typeConverter;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private boolean autoGrowNestedPaths = true;
    private int autoGrowCollectionLimit = 256;
    private String[] allowedFields;
    private String[] disallowedFields;
    private String[] requiredFields;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    private final List<Validator> validators = new ArrayList<Validator>();
    private ConversionService conversionService;

    public DataBinder(Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(Object target, String objectName) {
        this.target = ObjectUtils.unwrapOptional((Object)target);
        this.objectName = objectName;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call setAutoGrowNestedPaths before other configuration methods");
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public boolean isAutoGrowNestedPaths() {
        return this.autoGrowNestedPaths;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void initBeanPropertyAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initBeanPropertyAccess before other configuration methods");
        this.bindingResult = this.createBeanPropertyBindingResult();
    }

    protected AbstractPropertyBindingResult createBeanPropertyBindingResult() {
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        return result;
    }

    public void initDirectFieldAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initDirectFieldAccess before other configuration methods");
        this.bindingResult = this.createDirectFieldBindingResult();
    }

    protected AbstractPropertyBindingResult createDirectFieldBindingResult() {
        DirectFieldBindingResult result = new DirectFieldBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        return result;
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    protected SimpleTypeConverter getSimpleTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new SimpleTypeConverter();
            if (this.conversionService != null) {
                this.typeConverter.setConversionService(this.conversionService);
            }
        }
        return this.typeConverter;
    }

    protected PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    protected TypeConverter getTypeConverter() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String ... allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])allowedFields);
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String ... disallowedFields) {
        this.disallowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])disallowedFields);
    }

    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String ... requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString((Object[])requiredFields) + "]"));
        }
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.getPropertyAccessor().setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.getInternalBindingResult().setMessageCodesResolver(messageCodesResolver);
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        Assert.notNull((Object)bindingErrorProcessor, (String)"BindingErrorProcessor must not be null");
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void setValidator(Validator validator) {
        this.assertValidators(validator);
        this.validators.clear();
        this.validators.add(validator);
    }

    private void assertValidators(Validator ... validators) {
        Assert.notNull((Object)validators, (String)"Validators required");
        for (Validator validator : validators) {
            if (validator == null || this.getTarget() == null || validator.supports(this.getTarget().getClass())) continue;
            throw new IllegalStateException("Invalid target for Validator [" + validator + "]: " + this.getTarget());
        }
    }

    public void addValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.addAll(Arrays.asList(validators));
    }

    public void replaceValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.clear();
        this.validators.addAll(Arrays.asList(validators));
    }

    public Validator getValidator() {
        return this.validators.size() > 0 ? this.validators.get(0) : null;
    }

    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.state((this.conversionService == null ? 1 : 0) != 0, (String)"DataBinder is already initialized with ConversionService");
        this.conversionService = conversionService;
        if (this.bindingResult != null && conversionService != null) {
            this.bindingResult.initConversion(conversionService);
        }
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addCustomFormatter(Formatter<?> formatter) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        this.getPropertyEditorRegistry().registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
    }

    public void addCustomFormatter(Formatter<?> formatter, String ... fields) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        Class<?> fieldType = adapter.getFieldType();
        if (ObjectUtils.isEmpty((Object[])fields)) {
            this.getPropertyEditorRegistry().registerCustomEditor(fieldType, (PropertyEditor)adapter);
        } else {
            for (String field : fields) {
                this.getPropertyEditorRegistry().registerCustomEditor(fieldType, field, (PropertyEditor)adapter);
            }
        }
    }

    public void addCustomFormatter(Formatter<?> formatter, Class<?> ... fieldTypes) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        if (ObjectUtils.isEmpty((Object[])fieldTypes)) {
            this.getPropertyEditorRegistry().registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
        } else {
            for (Class<?> fieldType : fieldTypes) {
                this.getPropertyEditorRegistry().registerCustomEditor(fieldType, (PropertyEditor)adapter);
            }
        }
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class<?> requiredType, String field, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class<?> requiredType, String propertyPath) {
        return this.getPropertyEditorRegistry().findCustomEditor(requiredType, propertyPath);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, methodParam);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, field);
    }

    public void bind(PropertyValues pvs) {
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (MutablePropertyValues)pvs : new MutablePropertyValues(pvs);
        this.doBind(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkAllowedFields(mpvs);
        this.checkRequiredFields(mpvs);
        this.applyPropertyValues(mpvs);
    }

    protected void checkAllowedFields(MutablePropertyValues mpvs) {
        PropertyValue[] pvs;
        for (PropertyValue pv : pvs = mpvs.getPropertyValues()) {
            String field = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
            if (this.isAllowed(field)) continue;
            mpvs.removePropertyValue(pv);
            this.getBindingResult().recordSuppressedField(field);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Field [" + field + "] has been removed from PropertyValues " + "and will not be bound, because it has not been found in the list of allowed fields"));
        }
    }

    protected boolean isAllowed(String field) {
        Object[] allowed = this.getAllowedFields();
        Object[] disallowed = this.getDisallowedFields();
        return !(!ObjectUtils.isEmpty((Object[])allowed) && !PatternMatchUtils.simpleMatch((String[])allowed, (String)field) || !ObjectUtils.isEmpty((Object[])disallowed) && PatternMatchUtils.simpleMatch((String[])disallowed, (String)field));
    }

    protected void checkRequiredFields(MutablePropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (!ObjectUtils.isEmpty((Object[])requiredFields)) {
            PropertyValue[] pvs;
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            for (PropertyValue propertyValue : pvs = mpvs.getPropertyValues()) {
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)propertyValue.getName());
                propertyValues.put(canonicalName, propertyValue);
            }
            for (Object object : requiredFields) {
                boolean empty;
                PropertyValue pv = (PropertyValue)propertyValues.get(object);
                boolean bl = empty = pv == null || pv.getValue() == null;
                if (!empty) {
                    if (pv.getValue() instanceof String) {
                        empty = !StringUtils.hasText((String)((String)pv.getValue()));
                    } else if (pv.getValue() instanceof String[]) {
                        String[] values = (String[])pv.getValue();
                        boolean bl2 = empty = values.length == 0 || !StringUtils.hasText((String)values[0]);
                    }
                }
                if (!empty) continue;
                this.getBindingErrorProcessor().processMissingFieldError((String)object, this.getInternalBindingResult());
                if (pv == null) continue;
                mpvs.removePropertyValue(pv);
                propertyValues.remove(object);
            }
        }
    }

    protected void applyPropertyValues(MutablePropertyValues mpvs) {
        try {
            this.getPropertyAccessor().setPropertyValues((PropertyValues)mpvs, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
        }
        catch (PropertyBatchUpdateException ex) {
            for (PropertyAccessException pae : ex.getPropertyAccessExceptions()) {
                this.getBindingErrorProcessor().processPropertyAccessException(pae, this.getInternalBindingResult());
            }
        }
    }

    public void validate() {
        for (Validator validator : this.validators) {
            validator.validate(this.getTarget(), this.getBindingResult());
        }
    }

    public void validate(Object ... validationHints) {
        for (Validator validator : this.getValidators()) {
            if (!ObjectUtils.isEmpty((Object[])validationHints) && validator instanceof SmartValidator) {
                ((SmartValidator)validator).validate(this.getTarget(), this.getBindingResult(), validationHints);
                continue;
            }
            if (validator == null) continue;
            validator.validate(this.getTarget(), this.getBindingResult());
        }
    }

    public Map<?, ?> close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }
}

