/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CandidateComponentsIndex {
    private final MultiValueMap<String, String> index;

    CandidateComponentsIndex(List<Properties> content) {
        this.index = CandidateComponentsIndex.parseIndex(content);
    }

    public Set<String> getCandidateTypes(String basePackage, String stereotype) {
        List candidates = (List)this.index.get((Object)stereotype);
        if (candidates != null) {
            return candidates.parallelStream().filter(t -> t.startsWith(basePackage)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static MultiValueMap<String, String> parseIndex(List<Properties> content) {
        LinkedMultiValueMap index = new LinkedMultiValueMap();
        for (Properties entry : content) {
            for (Map.Entry<Object, Object> entries : entry.entrySet()) {
                String[] stereotypes;
                String type = (String)entries.getKey();
                for (String stereotype : stereotypes = ((String)entries.getValue()).split(",")) {
                    index.add((Object)stereotype, (Object)type);
                }
            }
        }
        return index;
    }
}

