/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.ConditionEvaluator;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportRegistry;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.ParserStrategyUtils;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.NestedIOException;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class ConfigurationClassParser {
    private static final PropertySourceFactory DEFAULT_PROPERTY_SOURCE_FACTORY = new DefaultPropertySourceFactory();
    private static final Comparator<DeferredImportSelectorHolder> DEFERRED_IMPORT_COMPARATOR = new Comparator<DeferredImportSelectorHolder>(){

        @Override
        public int compare(DeferredImportSelectorHolder o1, DeferredImportSelectorHolder o2) {
            return AnnotationAwareOrderComparator.INSTANCE.compare((Object)o1.getImportSelector(), (Object)o2.getImportSelector());
        }
    };
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;
    private final ConditionEvaluator conditionEvaluator;
    private final Map<ConfigurationClass, ConfigurationClass> configurationClasses = new LinkedHashMap<ConfigurationClass, ConfigurationClass>();
    private final Map<String, ConfigurationClass> knownSuperclasses = new HashMap<String, ConfigurationClass>();
    private final List<String> propertySourceNames = new ArrayList<String>();
    private final ImportStack importStack = new ImportStack();
    private List<DeferredImportSelectorHolder> deferredImportSelectors;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanNameGenerator componentScanBeanNameGenerator, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(environment, resourceLoader, componentScanBeanNameGenerator, registry);
        this.conditionEvaluator = new ConditionEvaluator(registry, environment, resourceLoader);
    }

    public void parse(Set<BeanDefinitionHolder> configCandidates) {
        this.deferredImportSelectors = new LinkedList<DeferredImportSelectorHolder>();
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AnnotatedBeanDefinition) {
                    this.parse(((AnnotatedBeanDefinition)bd).getMetadata(), holder.getBeanName());
                    continue;
                }
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    this.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                this.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to parse configuration class [" + bd.getBeanClassName() + "]", ex);
            }
        }
        this.processDeferredImportSelectors();
    }

    protected final void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    protected final void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    protected final void parse(AnnotationMetadata metadata, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(metadata, beanName));
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses.keySet()) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses.keySet();
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        if (this.conditionEvaluator.shouldSkip((AnnotatedTypeMetadata)configClass.getMetadata(), ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION)) {
            return;
        }
        ConfigurationClass existingClass = this.configurationClasses.get(configClass);
        if (existingClass != null) {
            if (configClass.isImported()) {
                if (existingClass.isImported()) {
                    existingClass.mergeImportedBy(configClass);
                }
                return;
            }
            this.configurationClasses.remove(configClass);
            Iterator<ConfigurationClass> it = this.knownSuperclasses.values().iterator();
            while (it.hasNext()) {
                if (!configClass.equals(it.next())) continue;
                it.remove();
            }
        }
        SourceClass sourceClass = this.asSourceClass(configClass);
        while ((sourceClass = this.doProcessConfigurationClass(configClass, sourceClass)) != null) {
        }
        this.configurationClasses.put(configClass, configClass);
    }

    protected final SourceClass doProcessConfigurationClass(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        String superclass;
        this.processMemberClasses(configClass, sourceClass);
        for (AnnotationAttributes annotationAttributes : AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), PropertySources.class, PropertySource.class)) {
            if (this.environment instanceof ConfigurableEnvironment) {
                this.processPropertySource(annotationAttributes);
                continue;
            }
            this.logger.warn((Object)("Ignoring @PropertySource annotation on [" + sourceClass.getMetadata().getClassName() + "]. Reason: Environment must implement ConfigurableEnvironment"));
        }
        Set<AnnotationAttributes> componentScans = AnnotationConfigUtils.attributesForRepeatable(sourceClass.getMetadata(), ComponentScans.class, ComponentScan.class);
        if (!componentScans.isEmpty() && !this.conditionEvaluator.shouldSkip((AnnotatedTypeMetadata)sourceClass.getMetadata(), ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN)) {
            for (AnnotationAttributes componentScan : componentScans) {
                Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScan, sourceClass.getMetadata().getClassName());
                for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                    if (!ConfigurationClassUtils.checkConfigurationClassCandidate(holder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                    this.parse(holder.getBeanDefinition().getBeanClassName(), holder.getBeanName());
                }
            }
        }
        this.processImports(configClass, sourceClass, this.getImports(sourceClass), true);
        if (sourceClass.getMetadata().isAnnotated(ImportResource.class.getName())) {
            AnnotationAttributes annotationAttributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)sourceClass.getMetadata(), ImportResource.class);
            String[] resources = annotationAttributes.getStringArray("locations");
            Class readerClass = annotationAttributes.getClass("reader");
            for (String resource : resources) {
                String resolvedResource = this.environment.resolveRequiredPlaceholders(resource);
                configClass.addImportedResource(resolvedResource, readerClass);
            }
        }
        Set<MethodMetadata> set = this.retrieveBeanMethodMetadata(sourceClass);
        for (MethodMetadata methodMetadata : set) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        this.processInterfaces(configClass, sourceClass);
        if (sourceClass.getMetadata().hasSuperClass() && !(superclass = sourceClass.getMetadata().getSuperClassName()).startsWith("java") && !this.knownSuperclasses.containsKey(superclass)) {
            this.knownSuperclasses.put(superclass, configClass);
            return sourceClass.getSuperClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemberClasses(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        for (SourceClass memberClass : sourceClass.getMemberClasses()) {
            if (!ConfigurationClassUtils.isConfigurationCandidate(memberClass.getMetadata()) || memberClass.getMetadata().getClassName().equals(configClass.getMetadata().getClassName())) continue;
            if (this.importStack.contains(configClass)) {
                this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack));
                continue;
            }
            this.importStack.push(configClass);
            try {
                this.processConfigurationClass(memberClass.asConfigClass(configClass));
            }
            finally {
                this.importStack.pop();
            }
        }
    }

    private void processInterfaces(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        for (SourceClass ifc : sourceClass.getInterfaces()) {
            Set<MethodMetadata> beanMethods = this.retrieveBeanMethodMetadata(ifc);
            for (MethodMetadata methodMetadata : beanMethods) {
                if (methodMetadata.isAbstract()) continue;
                configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
            }
            this.processInterfaces(configClass, ifc);
        }
    }

    private Set<MethodMetadata> retrieveBeanMethodMetadata(SourceClass sourceClass) {
        AnnotationMetadata original = sourceClass.getMetadata();
        LinkedHashSet<MethodMetadata> beanMethods = original.getAnnotatedMethods(Bean.class.getName());
        if (beanMethods.size() > 1 && original instanceof StandardAnnotationMetadata) {
            try {
                AnnotationMetadata asm = this.metadataReaderFactory.getMetadataReader(original.getClassName()).getAnnotationMetadata();
                Set asmMethods = asm.getAnnotatedMethods(Bean.class.getName());
                if (asmMethods.size() >= beanMethods.size()) {
                    LinkedHashSet<MethodMetadata> selectedMethods = new LinkedHashSet<MethodMetadata>(asmMethods.size());
                    block2: for (MethodMetadata asmMethod : asmMethods) {
                        for (MethodMetadata beanMethod : beanMethods) {
                            if (!beanMethod.getMethodName().equals(asmMethod.getMethodName())) continue;
                            selectedMethods.add(beanMethod);
                            continue block2;
                        }
                    }
                    if (selectedMethods.size() == beanMethods.size()) {
                        beanMethods = selectedMethods;
                    }
                }
            }
            catch (IOException ex) {
                this.logger.debug((Object)"Failed to read class file via ASM for determining @Bean method order", (Throwable)ex);
            }
        }
        return beanMethods;
    }

    private void processPropertySource(AnnotationAttributes propertySource) throws IOException {
        String[] locations;
        String encoding;
        String name = propertySource.getString("name");
        if (!StringUtils.hasLength((String)name)) {
            name = null;
        }
        if (!StringUtils.hasLength((String)(encoding = propertySource.getString("encoding")))) {
            encoding = null;
        }
        Assert.isTrue(((locations = propertySource.getStringArray("value")).length > 0 ? 1 : 0) != 0, (String)"At least one @PropertySource(value) location is required");
        boolean ignoreResourceNotFound = propertySource.getBoolean("ignoreResourceNotFound");
        Class factoryClass = propertySource.getClass("factory");
        PropertySourceFactory factory = factoryClass == PropertySourceFactory.class ? DEFAULT_PROPERTY_SOURCE_FACTORY : (PropertySourceFactory)BeanUtils.instantiateClass((Class)factoryClass);
        for (String location : locations) {
            try {
                String resolvedLocation = this.environment.resolveRequiredPlaceholders(location);
                Resource resource = this.resourceLoader.getResource(resolvedLocation);
                this.addPropertySource(factory.createPropertySource(name, new EncodedResource(resource, encoding)));
            }
            catch (FileNotFoundException | IllegalArgumentException ex) {
                if (ignoreResourceNotFound) {
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Properties location [" + location + "] not resolvable: " + ex.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
    }

    private void addPropertySource(org.springframework.core.env.PropertySource<?> propertySource) {
        String name = propertySource.getName();
        MutablePropertySources propertySources = ((ConfigurableEnvironment)this.environment).getPropertySources();
        if (propertySources.contains(name) && this.propertySourceNames.contains(name)) {
            ResourcePropertySource newSource;
            org.springframework.core.env.PropertySource existing = propertySources.get(name);
            ResourcePropertySource resourcePropertySource = newSource = propertySource instanceof ResourcePropertySource ? ((ResourcePropertySource)propertySource).withResourceName() : propertySource;
            if (existing instanceof CompositePropertySource) {
                ((CompositePropertySource)existing).addFirstPropertySource((org.springframework.core.env.PropertySource)newSource);
            } else {
                if (existing instanceof ResourcePropertySource) {
                    existing = ((ResourcePropertySource)existing).withResourceName();
                }
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource((org.springframework.core.env.PropertySource)newSource);
                composite.addPropertySource(existing);
                propertySources.replace(name, (org.springframework.core.env.PropertySource)composite);
            }
        } else if (this.propertySourceNames.isEmpty()) {
            propertySources.addLast(propertySource);
        } else {
            String firstProcessed = this.propertySourceNames.get(this.propertySourceNames.size() - 1);
            propertySources.addBefore(firstProcessed, (org.springframework.core.env.PropertySource)propertySource);
        }
        this.propertySourceNames.add(name);
    }

    private Set<SourceClass> getImports(SourceClass sourceClass) throws IOException {
        LinkedHashSet<SourceClass> imports = new LinkedHashSet<SourceClass>();
        LinkedHashSet<SourceClass> visited = new LinkedHashSet<SourceClass>();
        this.collectImports(sourceClass, imports, visited);
        return imports;
    }

    private void collectImports(SourceClass sourceClass, Set<SourceClass> imports, Set<SourceClass> visited) throws IOException {
        if (visited.add(sourceClass)) {
            for (SourceClass annotation : sourceClass.getAnnotations()) {
                String annName = annotation.getMetadata().getClassName();
                if (annName.startsWith("java") || annName.equals(Import.class.getName())) continue;
                this.collectImports(annotation, imports, visited);
            }
            imports.addAll(sourceClass.getAnnotationAttributes(Import.class.getName(), "value"));
        }
    }

    private void processDeferredImportSelectors() {
        List<DeferredImportSelectorHolder> deferredImports = this.deferredImportSelectors;
        this.deferredImportSelectors = null;
        Collections.sort(deferredImports, DEFERRED_IMPORT_COMPARATOR);
        for (DeferredImportSelectorHolder deferredImport : deferredImports) {
            ConfigurationClass configClass = deferredImport.getConfigurationClass();
            try {
                String[] imports = deferredImport.getImportSelector().selectImports(configClass.getMetadata());
                this.processImports(configClass, this.asSourceClass(configClass), this.asSourceClasses(imports), false);
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configClass.getMetadata().getClassName() + "]", ex);
            }
        }
    }

    private void processImports(ConfigurationClass configClass, SourceClass currentSourceClass, Collection<SourceClass> importCandidates, boolean checkForCircularImports) throws IOException {
        if (importCandidates.isEmpty()) {
            return;
        }
        if (checkForCircularImports && this.isChainedImportOnStack(configClass)) {
            this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack));
        } else {
            this.importStack.push(configClass);
            try {
                for (SourceClass candidate : importCandidates) {
                    Class<?> candidateClass;
                    if (candidate.isAssignable(ImportSelector.class)) {
                        candidateClass = candidate.loadClass();
                        ImportSelector selector = (ImportSelector)BeanUtils.instantiateClass(candidateClass, ImportSelector.class);
                        ParserStrategyUtils.invokeAwareMethods(selector, this.environment, this.resourceLoader, this.registry);
                        if (this.deferredImportSelectors != null && selector instanceof DeferredImportSelector) {
                            this.deferredImportSelectors.add(new DeferredImportSelectorHolder(configClass, (DeferredImportSelector)selector));
                            continue;
                        }
                        String[] importClassNames = selector.selectImports(currentSourceClass.getMetadata());
                        Collection<SourceClass> importSourceClasses = this.asSourceClasses(importClassNames);
                        this.processImports(configClass, currentSourceClass, importSourceClasses, false);
                        continue;
                    }
                    if (candidate.isAssignable(ImportBeanDefinitionRegistrar.class)) {
                        candidateClass = candidate.loadClass();
                        ImportBeanDefinitionRegistrar registrar = (ImportBeanDefinitionRegistrar)BeanUtils.instantiateClass(candidateClass, ImportBeanDefinitionRegistrar.class);
                        ParserStrategyUtils.invokeAwareMethods(registrar, this.environment, this.resourceLoader, this.registry);
                        configClass.addImportBeanDefinitionRegistrar(registrar, currentSourceClass.getMetadata());
                        continue;
                    }
                    this.importStack.registerImport(currentSourceClass.getMetadata(), candidate.getMetadata().getClassName());
                    this.processConfigurationClass(candidate.asConfigClass(configClass));
                }
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configClass.getMetadata().getClassName() + "]", ex);
            }
            finally {
                this.importStack.pop();
            }
        }
    }

    private boolean isChainedImportOnStack(ConfigurationClass configClass) {
        if (this.importStack.contains(configClass)) {
            String configClassName = configClass.getMetadata().getClassName();
            AnnotationMetadata importingClass = this.importStack.getImportingClassFor(configClassName);
            while (importingClass != null) {
                if (configClassName.equals(importingClass.getClassName())) {
                    return true;
                }
                importingClass = this.importStack.getImportingClassFor(importingClass.getClassName());
            }
        }
        return false;
    }

    ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    private SourceClass asSourceClass(ConfigurationClass configurationClass) throws IOException {
        AnnotationMetadata metadata = configurationClass.getMetadata();
        if (metadata instanceof StandardAnnotationMetadata) {
            return this.asSourceClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass());
        }
        return this.asSourceClass(metadata.getClassName());
    }

    SourceClass asSourceClass(Class<?> classType) throws IOException {
        try {
            classType.getAnnotations();
            return new SourceClass(classType);
        }
        catch (Throwable ex) {
            return this.asSourceClass(classType.getName());
        }
    }

    private Collection<SourceClass> asSourceClasses(String[] classNames) throws IOException {
        ArrayList<SourceClass> annotatedClasses = new ArrayList<SourceClass>(classNames.length);
        for (String className : classNames) {
            annotatedClasses.add(this.asSourceClass(className));
        }
        return annotatedClasses;
    }

    SourceClass asSourceClass(String className) throws IOException {
        if (className.startsWith("java")) {
            try {
                return new SourceClass(this.resourceLoader.getClassLoader().loadClass(className));
            }
            catch (ClassNotFoundException ex) {
                throw new NestedIOException("Failed to load class [" + className + "]", (Throwable)ex);
            }
        }
        return new SourceClass(this.metadataReaderFactory.getMetadataReader(className));
    }

    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Deque<ConfigurationClass> importStack) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack %s", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), (Object)attemptedImport.getMetadata()));
        }
    }

    private class SourceClass {
        private final Object source;
        private final AnnotationMetadata metadata;

        public SourceClass(Object source) {
            this.source = source;
            this.metadata = source instanceof Class ? new StandardAnnotationMetadata((Class)source, true) : ((MetadataReader)source).getAnnotationMetadata();
        }

        public final AnnotationMetadata getMetadata() {
            return this.metadata;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.source instanceof Class) {
                return (Class)this.source;
            }
            String className = ((MetadataReader)this.source).getClassMetadata().getClassName();
            return ConfigurationClassParser.this.resourceLoader.getClassLoader().loadClass(className);
        }

        public boolean isAssignable(Class<?> clazz) throws IOException {
            if (this.source instanceof Class) {
                return clazz.isAssignableFrom((Class)this.source);
            }
            return new AssignableTypeFilter(clazz).match((MetadataReader)this.source, ConfigurationClassParser.this.metadataReaderFactory);
        }

        public ConfigurationClass asConfigClass(ConfigurationClass importedBy) throws IOException {
            if (this.source instanceof Class) {
                return new ConfigurationClass((Class)this.source, importedBy);
            }
            return new ConfigurationClass((MetadataReader)this.source, importedBy);
        }

        public Collection<SourceClass> getMemberClasses() throws IOException {
            Object sourceToProcess = this.source;
            if (sourceToProcess instanceof Class) {
                Class sourceClass = (Class)sourceToProcess;
                try {
                    Class<?>[] declaredClasses = sourceClass.getDeclaredClasses();
                    ArrayList<SourceClass> members = new ArrayList<SourceClass>(declaredClasses.length);
                    for (Class<?> declaredClass : declaredClasses) {
                        members.add(ConfigurationClassParser.this.asSourceClass(declaredClass));
                    }
                    return members;
                }
                catch (NoClassDefFoundError err) {
                    sourceToProcess = ConfigurationClassParser.this.metadataReaderFactory.getMetadataReader(sourceClass.getName());
                }
            }
            MetadataReader sourceReader = (MetadataReader)sourceToProcess;
            String[] memberClassNames = sourceReader.getClassMetadata().getMemberClassNames();
            ArrayList<SourceClass> members = new ArrayList<SourceClass>(memberClassNames.length);
            for (String memberClassName : memberClassNames) {
                try {
                    members.add(ConfigurationClassParser.this.asSourceClass(memberClassName));
                }
                catch (IOException ex) {
                    if (!ConfigurationClassParser.this.logger.isDebugEnabled()) continue;
                    ConfigurationClassParser.this.logger.debug((Object)("Failed to resolve member class [" + memberClassName + "] - not considering it as a configuration class candidate"));
                }
            }
            return members;
        }

        public SourceClass getSuperClass() throws IOException {
            if (this.source instanceof Class) {
                return ConfigurationClassParser.this.asSourceClass(((Class)this.source).getSuperclass());
            }
            return ConfigurationClassParser.this.asSourceClass(((MetadataReader)this.source).getClassMetadata().getSuperClassName());
        }

        public Set<SourceClass> getInterfaces() throws IOException {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            if (this.source instanceof Class) {
                Class sourceClass = (Class)this.source;
                for (Class<?> ifcClass : sourceClass.getInterfaces()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(ifcClass));
                }
            } else {
                for (String className : this.metadata.getInterfaceNames()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(className));
                }
            }
            return result;
        }

        public Set<SourceClass> getAnnotations() throws IOException {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            for (String className : this.metadata.getAnnotationTypes()) {
                try {
                    result.add(this.getRelated(className));
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        public Collection<SourceClass> getAnnotationAttributes(String annotationType, String attribute) throws IOException {
            Map annotationAttributes = this.metadata.getAnnotationAttributes(annotationType, true);
            if (annotationAttributes == null || !annotationAttributes.containsKey(attribute)) {
                return Collections.emptySet();
            }
            String[] classNames = (String[])annotationAttributes.get(attribute);
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            for (String className : classNames) {
                result.add(this.getRelated(className));
            }
            return result;
        }

        private SourceClass getRelated(String className) throws IOException {
            if (this.source instanceof Class) {
                try {
                    Class<?> clazz = ((Class)this.source).getClassLoader().loadClass(className);
                    return ConfigurationClassParser.this.asSourceClass(clazz);
                }
                catch (ClassNotFoundException ex) {
                    if (className.startsWith("java")) {
                        throw new NestedIOException("Failed to load class [" + className + "]", (Throwable)ex);
                    }
                    return new SourceClass(ConfigurationClassParser.this.metadataReaderFactory.getMetadataReader(className));
                }
            }
            return ConfigurationClassParser.this.asSourceClass(className);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SourceClass && this.metadata.getClassName().equals(((SourceClass)other).metadata.getClassName());
        }

        public int hashCode() {
            return this.metadata.getClassName().hashCode();
        }

        public String toString() {
            return this.metadata.getClassName();
        }
    }

    private static class DeferredImportSelectorHolder {
        private final ConfigurationClass configurationClass;
        private final DeferredImportSelector importSelector;

        public DeferredImportSelectorHolder(ConfigurationClass configurationClass, DeferredImportSelector importSelector) {
            this.configurationClass = configurationClass;
            this.importSelector = importSelector;
        }

        public ConfigurationClass getConfigurationClass() {
            return this.configurationClass;
        }

        public DeferredImportSelector getImportSelector() {
            return this.importSelector;
        }
    }

    private static class ImportStack
    extends ArrayDeque<ConfigurationClass>
    implements ImportRegistry {
        private final MultiValueMap<String, AnnotationMetadata> imports = new LinkedMultiValueMap();

        private ImportStack() {
        }

        public void registerImport(AnnotationMetadata importingClass, String importedClass) {
            this.imports.add((Object)importedClass, (Object)importingClass);
        }

        @Override
        public AnnotationMetadata getImportingClassFor(String importedClass) {
            List list = (List)this.imports.get((Object)importedClass);
            return !CollectionUtils.isEmpty((Collection)list) ? (AnnotationMetadata)list.get(list.size() - 1) : null;
        }

        @Override
        public void removeImportingClass(String importingClass) {
            block0: for (List list : this.imports.values()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!((AnnotationMetadata)iterator.next()).getClassName().equals(importingClass)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }
}

