/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.Conventions;
import org.springframework.ui.Model;
import org.springframework.util.Assert;

public class ConcurrentModel
extends ConcurrentHashMap<String, Object>
implements Model {
    public ConcurrentModel() {
    }

    public ConcurrentModel(String attributeName, Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ConcurrentModel(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    @Override
    public ConcurrentModel addAttribute(String attributeName, Object attributeValue) {
        Assert.notNull((Object)attributeName, (String)"Model attribute name must not be null");
        this.put(attributeName, attributeValue);
        return this;
    }

    @Override
    public ConcurrentModel addAttribute(Object attributeValue) {
        Assert.notNull((Object)attributeValue, (String)"Model object must not be null");
        if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName((Object)attributeValue), attributeValue);
    }

    @Override
    public ConcurrentModel addAllAttributes(Collection<?> attributeValues) {
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                this.addAttribute(attributeValue);
            }
        }
        return this;
    }

    @Override
    public ConcurrentModel addAllAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            this.putAll(attributes);
        }
        return this;
    }

    @Override
    public ConcurrentModel mergeAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                String key = entry.getKey();
                if (this.containsKey(key)) continue;
                this.put(key, entry.getValue());
            }
        }
        return this;
    }

    @Override
    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    @Override
    public Map<String, Object> asMap() {
        return this;
    }
}

