/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ScheduledAnnotationBeanPostProcessor
implements MergedBeanDefinitionPostProcessor,
DestructionAwareBeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
BeanNameAware,
BeanFactoryAware,
ApplicationContextAware,
SmartInitializingSingleton,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    public static final String DEFAULT_TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private String beanName;
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private final ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Map<Object, Set<ScheduledTask>> scheduledTasks = new IdentityHashMap<Object, Set<ScheduledTask>>(16);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.beanFactory == null) {
            this.beanFactory = applicationContext;
        }
    }

    public void afterSingletonsInstantiated() {
        this.nonAnnotatedClasses.clear();
        if (this.applicationContext == null) {
            this.finishRegistration();
        }
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.finishRegistration();
        }
    }

    private void finishRegistration() {
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map configurers = ((ListableBeanFactory)this.beanFactory).getBeansOfType(SchedulingConfigurer.class);
            for (SchedulingConfigurer configurer : configurers.values()) {
                configurer.configureTasks(this.registrar);
            }
        }
        if (this.registrar.hasTasks() && this.registrar.getScheduler() == null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find scheduler by type");
            try {
                this.registrar.setTaskScheduler(this.resolveSchedulerBean(TaskScheduler.class, false));
            }
            catch (NoUniqueBeanDefinitionException ex) {
                this.logger.debug((Object)"Could not find unique TaskScheduler bean", (Throwable)ex);
                try {
                    this.registrar.setTaskScheduler(this.resolveSchedulerBean(TaskScheduler.class, true));
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("More than one TaskScheduler bean exists within the context, and none is named 'taskScheduler'. Mark one of them as primary or name it 'taskScheduler' (possibly as an alias); or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback: " + ex.getBeanNamesFound()));
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.debug((Object)"Could not find default TaskScheduler bean", (Throwable)ex);
                try {
                    this.registrar.setScheduler(this.resolveSchedulerBean(ScheduledExecutorService.class, false));
                }
                catch (NoUniqueBeanDefinitionException ex2) {
                    this.logger.debug((Object)"Could not find unique ScheduledExecutorService bean", (Throwable)ex2);
                    try {
                        this.registrar.setScheduler(this.resolveSchedulerBean(ScheduledExecutorService.class, true));
                    }
                    catch (NoSuchBeanDefinitionException ex3) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("More than one ScheduledExecutorService bean exists within the context, and none is named 'taskScheduler'. Mark one of them as primary or name it 'taskScheduler' (possibly as an alias); or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback: " + ex2.getBeanNamesFound()));
                        }
                    }
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    this.logger.debug((Object)"Could not find default ScheduledExecutorService bean", (Throwable)ex2);
                    this.logger.info((Object)"No TaskScheduler/ScheduledExecutorService bean found for scheduled processing");
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    private <T> T resolveSchedulerBean(Class<T> schedulerType, boolean byName) {
        if (byName) {
            Object scheduler = this.beanFactory.getBean(DEFAULT_TASK_SCHEDULER_BEAN_NAME, schedulerType);
            if (this.beanFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)this.beanFactory).registerDependentBean(DEFAULT_TASK_SCHEDULER_BEAN_NAME, this.beanName);
            }
            return (T)scheduler;
        }
        if (this.beanFactory instanceof AutowireCapableBeanFactory) {
            NamedBeanHolder holder = ((AutowireCapableBeanFactory)this.beanFactory).resolveNamedBean(schedulerType);
            if (this.beanFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)this.beanFactory).registerDependentBean(holder.getBeanName(), this.beanName);
            }
            return (T)holder.getBeanInstance();
        }
        return (T)this.beanFactory.getBean(schedulerType);
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass)) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set scheduledMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                return !scheduledMethods.isEmpty() ? scheduledMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @Scheduled annotations found on bean class: " + bean.getClass()));
                }
            } else {
                annotatedMethods.forEach((method, scheduledMethods) -> scheduledMethods.forEach(scheduled -> this.processScheduled((Scheduled)scheduled, (Method)method, bean)));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(annotatedMethods.size() + " @Scheduled methods processed on bean '" + beanName + "': " + annotatedMethods));
                }
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processScheduled(Scheduled scheduled, Method method, Object bean) {
        try {
            String fixedRateString;
            long fixedRate;
            String fixedDelayString;
            long fixedDelay;
            String cron;
            Assert.isTrue((method.getParameterCount() == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled");
            Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, bean.getClass());
            ScheduledMethodRunnable runnable = new ScheduledMethodRunnable(bean, invocableMethod);
            boolean processedSchedule = false;
            String errorMessage = "Exactly one of the 'cron', 'fixedDelay(String)', or 'fixedRate(String)' attributes is required";
            LinkedHashSet<ScheduledTask> tasks = new LinkedHashSet<ScheduledTask>(4);
            long initialDelay = scheduled.initialDelay();
            String initialDelayString = scheduled.initialDelayString();
            if (StringUtils.hasText((String)initialDelayString)) {
                Assert.isTrue((initialDelay < 0L ? 1 : 0) != 0, (String)"Specify 'initialDelay' or 'initialDelayString', not both");
                if (this.embeddedValueResolver != null) {
                    initialDelayString = this.embeddedValueResolver.resolveStringValue(initialDelayString);
                }
                if (StringUtils.hasLength((String)initialDelayString)) {
                    try {
                        initialDelay = Long.parseLong(initialDelayString);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid initialDelayString value \"" + initialDelayString + "\" - cannot parse into integer");
                    }
                }
            }
            if (StringUtils.hasText((String)(cron = scheduled.cron()))) {
                String zone = scheduled.zone();
                if (this.embeddedValueResolver != null) {
                    cron = this.embeddedValueResolver.resolveStringValue(cron);
                    zone = this.embeddedValueResolver.resolveStringValue(zone);
                }
                if (StringUtils.hasLength((String)cron)) {
                    Assert.isTrue((initialDelay == -1L ? 1 : 0) != 0, (String)"'initialDelay' not supported for cron triggers");
                    processedSchedule = true;
                    TimeZone timeZone = StringUtils.hasText((String)zone) ? StringUtils.parseTimeZoneString((String)zone) : TimeZone.getDefault();
                    tasks.add(this.registrar.scheduleCronTask(new CronTask((Runnable)runnable, new CronTrigger(cron, timeZone))));
                }
            }
            if (initialDelay < 0L) {
                initialDelay = 0L;
            }
            if ((fixedDelay = scheduled.fixedDelay()) >= 0L) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay)));
            }
            if (StringUtils.hasText((String)(fixedDelayString = scheduled.fixedDelayString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedDelayString = this.embeddedValueResolver.resolveStringValue(fixedDelayString);
                }
                if (StringUtils.hasLength((String)fixedDelayString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedDelay = Long.parseLong(fixedDelayString);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid fixedDelayString value \"" + fixedDelayString + "\" - cannot parse into long");
                    }
                    tasks.add(this.registrar.scheduleFixedDelayTask(new IntervalTask(runnable, fixedDelay, initialDelay)));
                }
            }
            if ((fixedRate = scheduled.fixedRate()) >= 0L) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay)));
            }
            if (StringUtils.hasText((String)(fixedRateString = scheduled.fixedRateString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedRateString = this.embeddedValueResolver.resolveStringValue(fixedRateString);
                }
                if (StringUtils.hasLength((String)fixedRateString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedRate = Long.parseLong(fixedRateString);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid fixedRateString value \"" + fixedRateString + "\" - cannot parse into integer");
                    }
                    tasks.add(this.registrar.scheduleFixedRateTask(new IntervalTask(runnable, fixedRate, initialDelay)));
                }
            }
            Assert.isTrue((boolean)processedSchedule, (String)errorMessage);
            Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
            synchronized (map) {
                Set<ScheduledTask> registeredTasks = this.scheduledTasks.get(bean);
                if (registeredTasks == null) {
                    registeredTasks = new LinkedHashSet<ScheduledTask>(4);
                    this.scheduledTasks.put(bean, registeredTasks);
                }
                registeredTasks.addAll(tasks);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Encountered invalid @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeforeDestruction(Object bean, String beanName) {
        Set<ScheduledTask> tasks;
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            tasks = this.scheduledTasks.remove(bean);
        }
        if (tasks != null) {
            for (ScheduledTask task : tasks) {
                task.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresDestruction(Object bean) {
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            return this.scheduledTasks.containsKey(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            Collection<Set<ScheduledTask>> allTasks = this.scheduledTasks.values();
            for (Set<ScheduledTask> tasks : allTasks) {
                for (ScheduledTask task : tasks) {
                    task.cancel();
                }
            }
            this.scheduledTasks.clear();
        }
        this.registrar.destroy();
    }
}

