/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aot.agent.InstrumentedBridgeMethods;
import org.springframework.aot.agent.InstrumentedMethod;
import org.springframework.aot.agent.MethodReference;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.Handle;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Opcodes;

class InvocationsRecorderClassVisitor
extends ClassVisitor
implements Opcodes {
    private boolean isTransformed;
    private final ClassWriter classWriter;

    public InvocationsRecorderClassVisitor() {
        this(new ClassWriter(1));
    }

    private InvocationsRecorderClassVisitor(ClassWriter classWriter) {
        super(0x10A0000, (ClassVisitor)classWriter);
        this.classWriter = classWriter;
    }

    public boolean isTransformed() {
        return this.isTransformed;
    }

    public byte[] getTransformedClassBuffer() {
        return this.classWriter.toByteArray();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new InvocationsRecorderMethodVisitor(mv);
    }

    class InvocationsRecorderMethodVisitor
    extends MethodVisitor
    implements Opcodes {
        private static final String INSTRUMENTED_CLASS = InstrumentedBridgeMethods.class.getName().replace('.', '/');
        private static final Set<String> instrumentedMethods = new HashSet<String>();

        public InvocationsRecorderMethodVisitor(MethodVisitor mv) {
            super(0x10A0000, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.isOpcodeSupported(opcode) && this.shouldRecordMethodCall(owner, name)) {
                String instrumentedMethodName = this.rewriteMethodName(owner, name);
                this.mv.visitMethodInsn(184, INSTRUMENTED_CLASS, instrumentedMethodName, this.rewriteDescriptor(opcode, owner, name, descriptor), false);
                InvocationsRecorderClassVisitor.this.isTransformed = true;
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }

        private boolean isOpcodeSupported(int opcode) {
            return 182 == opcode || 184 == opcode;
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                Handle argumentHandle;
                Object object = bootstrapMethodArguments[i];
                if (!(object instanceof Handle) || !this.shouldRecordMethodCall((argumentHandle = (Handle)object).getOwner(), argumentHandle.getName())) continue;
                String instrumentedMethodName = this.rewriteMethodName(argumentHandle.getOwner(), argumentHandle.getName());
                String newDescriptor = this.rewriteDescriptor(argumentHandle.getTag(), argumentHandle.getOwner(), argumentHandle.getName(), argumentHandle.getDesc());
                bootstrapMethodArguments[i] = new Handle(6, INSTRUMENTED_CLASS, instrumentedMethodName, newDescriptor, false);
                InvocationsRecorderClassVisitor.this.isTransformed = true;
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        private boolean shouldRecordMethodCall(String owner, String method) {
            String methodReference = owner + "#" + method;
            return instrumentedMethods.contains(methodReference);
        }

        private String rewriteMethodName(String owner, String methodName) {
            int classIndex = owner.lastIndexOf(47);
            return owner.substring(classIndex + 1).toLowerCase() + methodName;
        }

        private String rewriteDescriptor(int opcode, String owner, String name, String descriptor) {
            return opcode == 184 || opcode == 6 ? descriptor : "(L" + owner + ";" + descriptor.substring(1);
        }

        static {
            for (InstrumentedMethod method : InstrumentedMethod.values()) {
                MethodReference methodReference = method.methodReference();
                instrumentedMethods.add(methodReference.getClassName().replace('.', '/') + "#" + methodReference.getMethodName());
            }
        }
    }
}

