/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.springframework.core.test.tools.ClassFile;
import org.springframework.core.test.tools.ClassFiles;
import org.springframework.core.test.tools.DynamicClassFileObject;
import org.springframework.core.test.tools.DynamicResourceFileObject;
import org.springframework.core.test.tools.ResourceFile;
import org.springframework.core.test.tools.ResourceFiles;
import org.springframework.util.ClassUtils;

class DynamicJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoader classLoader;
    private final ClassFiles classFiles;
    private final ResourceFiles resourceFiles;
    private final Map<String, DynamicClassFileObject> dynamicClassFiles = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, DynamicResourceFileObject> dynamicResourceFiles = Collections.synchronizedMap(new LinkedHashMap());

    DynamicJavaFileManager(JavaFileManager fileManager, ClassLoader classLoader, ClassFiles classFiles, ResourceFiles resourceFiles) {
        super(fileManager);
        this.classFiles = classFiles;
        this.resourceFiles = resourceFiles;
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) {
        ResourceFile resourceFile = this.resourceFiles.get(relativeName);
        if (resourceFile != null) {
            return new DynamicResourceFileObject(relativeName, resourceFile.getContent());
        }
        return this.dynamicResourceFiles.computeIfAbsent(relativeName, DynamicResourceFileObject::new);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            ClassFile classFile = this.classFiles.get(className);
            if (classFile != null) {
                return new DynamicClassFileObject(className, classFile.getContent());
            }
            return this.dynamicClassFiles.computeIfAbsent(className, DynamicClassFileObject::new);
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        if (kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            String existingPackageName;
            for (ClassFile classFile : this.classFiles) {
                existingPackageName = ClassUtils.getPackageName((String)classFile.getName());
                if (!existingPackageName.equals(packageName) && (!recurse || !existingPackageName.startsWith(packageName + "."))) continue;
                result.add(new DynamicClassFileObject(classFile.getName(), classFile.getContent()));
            }
            for (DynamicClassFileObject dynamicClassFileObject : this.dynamicClassFiles.values()) {
                existingPackageName = ClassUtils.getPackageName((String)dynamicClassFileObject.getClassName());
                if (!existingPackageName.equals(packageName) && (!recurse || !existingPackageName.startsWith(packageName + "."))) continue;
                result.add(dynamicClassFileObject);
            }
        }
        super.list(location, packageName, kinds, recurse).forEach(result::add);
        return result;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof DynamicClassFileObject) {
            DynamicClassFileObject dynamicClassFileObject = (DynamicClassFileObject)file;
            return dynamicClassFileObject.getClassName();
        }
        return super.inferBinaryName(location, file);
    }

    Map<String, DynamicClassFileObject> getDynamicClassFiles() {
        return this.dynamicClassFiles;
    }

    Map<String, DynamicResourceFileObject> getDynamicResourceFiles() {
        return Collections.unmodifiableMap(this.dynamicResourceFiles);
    }
}

