/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.springframework.lang.Nullable;

class DynamicResourceFileObject
extends SimpleJavaFileObject {
    @Nullable
    private volatile byte[] bytes;

    DynamicResourceFileObject(String fileName) {
        super(DynamicResourceFileObject.createUri(fileName), JavaFileObject.Kind.OTHER);
    }

    DynamicResourceFileObject(String fileName, String content) {
        super(DynamicResourceFileObject.createUri(fileName), JavaFileObject.Kind.OTHER);
        this.bytes = content.getBytes();
    }

    private static URI createUri(String fileName) {
        return URI.create("resource:///" + fileName);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        byte[] content = this.bytes;
        if (content == null) {
            throw new IOException("No data written");
        }
        return new ByteArrayInputStream(content);
    }

    @Override
    public OutputStream openOutputStream() {
        return new JavaResourceOutputStream();
    }

    private void closeOutputStream(byte[] bytes) {
        this.bytes = bytes;
    }

    @Nullable
    byte[] getBytes() {
        return this.bytes;
    }

    class JavaResourceOutputStream
    extends ByteArrayOutputStream {
        JavaResourceOutputStream() {
        }

        @Override
        public void close() {
            DynamicResourceFileObject.this.closeOutputStream(this.toByteArray());
        }
    }
}

