/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.aot.agent.HintType;
import org.springframework.aot.agent.MethodReference;
import org.springframework.aot.agent.RecordedInvocation;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.hint.predicate.RuntimeHintsPredicates;

enum InstrumentedMethod {
    CLASS_FORNAME(Class.class, "forName", HintType.REFLECTION, invocation -> {
        String className = (String)invocation.getArgument(0);
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((String)className));
    }),
    CLASS_GETCLASSES(Class.class, "getClasses", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.DECLARED_CLASSES, MemberCategory.PUBLIC_CLASSES});
    }),
    CLASS_GETCONSTRUCTOR(Class.class, "getConstructor", HintType.REFLECTION, invocation -> {
        Constructor constructor = (Constructor)invocation.getReturnValue();
        if (constructor == null) {
            return runtimeHints -> false;
        }
        return RuntimeHintsPredicates.reflection().onConstructor(constructor).introspect();
    }),
    CLASS_GETCONSTRUCTORS(Class.class, "getConstructors", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }),
    CLASS_GETDECLAREDCLASSES(Class.class, "getDeclaredClasses", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withMemberCategory(MemberCategory.DECLARED_CLASSES);
    }),
    CLASS_GETDECLAREDCONSTRUCTOR(Class.class, "getDeclaredConstructor", HintType.REFLECTION, invocation -> {
        Constructor constructor = (Constructor)invocation.getReturnValue();
        if (constructor == null) {
            return runtimeHints -> false;
        }
        TypeReference thisType = invocation.getInstanceTypeReference();
        return RuntimeHintsPredicates.reflection().onType(thisType).withMemberCategory(MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS).or(RuntimeHintsPredicates.reflection().onConstructor(constructor).introspect());
    }),
    CLASS_GETDECLAREDCONSTRUCTORS(Class.class, "getDeclaredConstructors", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }),
    CLASS_GETDECLAREDFIELD(Class.class, "getDeclaredField", HintType.REFLECTION, invocation -> {
        Field field = (Field)invocation.getReturnValue();
        if (field == null) {
            return runtimeHints -> false;
        }
        TypeReference thisType = invocation.getInstanceTypeReference();
        return RuntimeHintsPredicates.reflection().onType(thisType).withMemberCategory(MemberCategory.DECLARED_FIELDS).or(RuntimeHintsPredicates.reflection().onField(field));
    }),
    CLASS_GETDECLAREDFIELDS(Class.class, "getDeclaredFields", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withMemberCategory(MemberCategory.DECLARED_FIELDS);
    }),
    CLASS_GETDECLAREDMETHOD(Class.class, "getDeclaredMethod", HintType.REFLECTION, invocation -> {
        Method method = (Method)invocation.getReturnValue();
        if (method == null) {
            return runtimeHints -> false;
        }
        TypeReference thisType = invocation.getInstanceTypeReference();
        return RuntimeHintsPredicates.reflection().onType(thisType).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS}).or(RuntimeHintsPredicates.reflection().onMethod(method).introspect());
    }),
    CLASS_GETDECLAREDMETHODS(Class.class, "getDeclaredMethods", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS});
    }),
    CLASS_GETFIELD(Class.class, "getField", HintType.REFLECTION, invocation -> {
        Field field = (Field)invocation.getReturnValue();
        if (field == null) {
            return runtimeHints -> false;
        }
        TypeReference thisType = invocation.getInstanceTypeReference();
        return RuntimeHintsPredicates.reflection().onType(thisType).withMemberCategory(MemberCategory.PUBLIC_FIELDS).and(runtimeHints -> Modifier.isPublic(field.getModifiers())).or(RuntimeHintsPredicates.reflection().onType(thisType).withMemberCategory(MemberCategory.DECLARED_FIELDS)).or((Predicate<RuntimeHints>)RuntimeHintsPredicates.reflection().onField((Field)invocation.getReturnValue()));
    }),
    CLASS_GETFIELDS(Class.class, "getFields", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.DECLARED_FIELDS});
    }),
    CLASS_GETMETHOD(Class.class, "getMethod", HintType.REFLECTION, invocation -> {
        Method method = (Method)invocation.getReturnValue();
        if (method == null) {
            return runtimeHints -> false;
        }
        TypeReference thisType = invocation.getInstanceTypeReference();
        return RuntimeHintsPredicates.reflection().onType(thisType).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}).and(runtimeHints -> Modifier.isPublic(method.getModifiers())).or(RuntimeHintsPredicates.reflection().onType(thisType).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_METHODS})).or((Predicate<RuntimeHints>)RuntimeHintsPredicates.reflection().onMethod(method).introspect()).or((Predicate<RuntimeHints>)RuntimeHintsPredicates.reflection().onMethod(method).invoke());
    }),
    CLASS_GETMETHODS(Class.class, "getMethods", HintType.REFLECTION, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        return RuntimeHintsPredicates.reflection().onType(TypeReference.of((Class)thisClass)).withAnyMemberCategory(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_METHODS});
    }),
    CLASSLOADER_LOADCLASS(ClassLoader.class, "loadClass", HintType.REFLECTION, invocation -> {
        Class klass = (Class)invocation.getReturnValue();
        if (klass == null) {
            return runtimeHints -> false;
        }
        return RuntimeHintsPredicates.reflection().onType(klass);
    }),
    CONSTRUCTOR_NEWINSTANCE(Constructor.class, "newInstance", HintType.REFLECTION, invocation -> RuntimeHintsPredicates.reflection().onConstructor((Constructor)invocation.getInstance()).invoke()),
    METHOD_INVOKE(Method.class, "invoke", HintType.REFLECTION, invocation -> RuntimeHintsPredicates.reflection().onMethod((Method)invocation.getInstance()).invoke()),
    FIELD_GET(Field.class, "get", HintType.REFLECTION, invocation -> RuntimeHintsPredicates.reflection().onField((Field)invocation.getInstance())),
    FIELD_SET(Field.class, "set", HintType.REFLECTION, invocation -> RuntimeHintsPredicates.reflection().onField((Field)invocation.getInstance())),
    RESOURCEBUNDLE_GETBUNDLE(ResourceBundle.class, "getBundle", HintType.RESOURCE_BUNDLE, invocation -> {
        String bundleName = (String)invocation.getArgument(0);
        return RuntimeHintsPredicates.resource().forBundle(bundleName);
    }),
    CLASS_GETRESOURCE(Class.class, "getResource", HintType.RESOURCE_PATTERN, invocation -> {
        Class thisClass = (Class)invocation.getInstance();
        String resourceName = (String)invocation.getArgument(0);
        return RuntimeHintsPredicates.resource().forResource(TypeReference.of((Class)thisClass), resourceName);
    }),
    CLASS_GETRESOURCEASSTREAM(Class.class, "getResourceAsStream", HintType.RESOURCE_PATTERN, InstrumentedMethod.CLASS_GETRESOURCE.hintsMatcherGenerator),
    CLASSLOADER_GETRESOURCE(ClassLoader.class, "getResource", HintType.RESOURCE_PATTERN, invocation -> {
        String resourceName = (String)invocation.getArgument(0);
        return RuntimeHintsPredicates.resource().forResource(resourceName);
    }),
    CLASSLOADER_GETRESOURCEASSTREAM(ClassLoader.class, "getResourceAsStream", HintType.RESOURCE_PATTERN, InstrumentedMethod.CLASSLOADER_GETRESOURCE.hintsMatcherGenerator),
    CLASSLOADER_GETRESOURCES(ClassLoader.class, "getResources", HintType.RESOURCE_PATTERN, InstrumentedMethod.CLASSLOADER_GETRESOURCE.hintsMatcherGenerator),
    MODULE_GETRESOURCEASSTREAM(Module.class, "getResourceAsStream", HintType.RESOURCE_PATTERN, InstrumentedMethod.CLASSLOADER_GETRESOURCE.hintsMatcherGenerator),
    CLASSLOADER_RESOURCES(ClassLoader.class, "resources", HintType.RESOURCE_PATTERN, InstrumentedMethod.CLASSLOADER_GETRESOURCE.hintsMatcherGenerator),
    PROXY_NEWPROXYINSTANCE(Proxy.class, "newProxyInstance", HintType.JDK_PROXIES, invocation -> {
        Class[] classes = (Class[])invocation.getArgument(1);
        return RuntimeHintsPredicates.proxies().forInterfaces(classes);
    });

    private final MethodReference methodReference;
    private final HintType hintType;
    private final Function<RecordedInvocation, Predicate<RuntimeHints>> hintsMatcherGenerator;

    private InstrumentedMethod(Class<?> klass, String methodName, HintType hintType, Function<RecordedInvocation, Predicate<RuntimeHints>> hintsMatcherGenerator) {
        this.methodReference = MethodReference.of(klass, methodName);
        this.hintType = hintType;
        this.hintsMatcherGenerator = hintsMatcherGenerator;
    }

    MethodReference methodReference() {
        return this.methodReference;
    }

    HintType getHintType() {
        return this.hintType;
    }

    Predicate<RuntimeHints> matcher(RecordedInvocation invocation) {
        return this.hintsMatcherGenerator.apply(invocation);
    }
}

