/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.springframework.aot.agent.InvocationsRecorderClassVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class InvocationsRecorderClassTransformer
implements ClassFileTransformer {
    private static final String AGENT_PACKAGE = InvocationsRecorderClassTransformer.class.getPackageName().replace('.', '/');
    private static final String AOT_DYNAMIC_CLASSLOADER = "org/springframework/aot/test/generate/compile/DynamicClassLoader";
    private final String[] instrumentedPackages;
    private final String[] ignoredPackages;

    public InvocationsRecorderClassTransformer(String[] instrumentedPackages, String[] ignoredPackages) {
        Assert.notNull((Object)instrumentedPackages, (String)"instrumentedPackages must not be null");
        Assert.notNull((Object)ignoredPackages, (String)"ignoredPackages must not be null");
        this.instrumentedPackages = this.rewriteToAsmFormat(instrumentedPackages);
        this.ignoredPackages = this.rewriteToAsmFormat(ignoredPackages);
    }

    private String[] rewriteToAsmFormat(String[] packages) {
        return (String[])Arrays.stream(packages).map(pack -> pack.replace('.', '/')).toArray(String[]::new);
    }

    @Override
    public byte[] transform(@Nullable ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.isTransformationCandidate(classLoader, className)) {
            return this.attemptClassTransformation(classfileBuffer);
        }
        return classfileBuffer;
    }

    private boolean isTransformationCandidate(@Nullable ClassLoader classLoader, String className) {
        if (classLoader == null) {
            return false;
        }
        if (className.startsWith(AGENT_PACKAGE) || className.equals(AOT_DYNAMIC_CLASSLOADER)) {
            return false;
        }
        if (className.contains("$$")) {
            return false;
        }
        for (String ignoredPackage : this.ignoredPackages) {
            if (!className.startsWith(ignoredPackage)) continue;
            return false;
        }
        for (String instrumentedPackage : this.instrumentedPackages) {
            if (!className.startsWith(instrumentedPackage)) continue;
            return true;
        }
        return false;
    }

    private byte[] attemptClassTransformation(byte[] classfileBuffer) {
        ClassReader fileReader = new ClassReader(classfileBuffer);
        InvocationsRecorderClassVisitor classVisitor = new InvocationsRecorderClassVisitor();
        try {
            fileReader.accept((ClassVisitor)classVisitor, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return classfileBuffer;
        }
        if (classVisitor.isTransformed()) {
            return classVisitor.getTransformedClassBuffer();
        }
        return classfileBuffer;
    }
}

