/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.generate;

import java.util.function.UnaryOperator;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.DefaultGenerationContext;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.InMemoryGeneratedFiles;
import org.springframework.aot.test.generate.CompilerFiles;
import org.springframework.core.test.tools.TestCompiler;
import org.springframework.javapoet.ClassName;

public class TestGenerationContext
extends DefaultGenerationContext
implements UnaryOperator<TestCompiler> {
    public static final ClassName TEST_TARGET = ClassName.get((String)"com.example", (String)"TestTarget", (String[])new String[0]);

    public TestGenerationContext(ClassNameGenerator classNameGenerator) {
        super(classNameGenerator, (GeneratedFiles)new InMemoryGeneratedFiles());
    }

    public TestGenerationContext(ClassName target) {
        this(new ClassNameGenerator(target));
    }

    public TestGenerationContext(Class<?> target) {
        this(ClassName.get(target));
    }

    public TestGenerationContext() {
        this(TEST_TARGET);
    }

    public InMemoryGeneratedFiles getGeneratedFiles() {
        return (InMemoryGeneratedFiles)super.getGeneratedFiles();
    }

    @Override
    public TestCompiler apply(TestCompiler testCompiler) {
        return (TestCompiler)CompilerFiles.from(this.getGeneratedFiles()).apply(testCompiler);
    }
}

