/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.test.tools.ClassFile;
import org.springframework.lang.Nullable;

public final class ClassFiles
implements Iterable<ClassFile> {
    private static final ClassFiles NONE = new ClassFiles(Collections.emptyMap());
    private final Map<String, ClassFile> files;

    private ClassFiles(Map<String, ClassFile> files) {
        this.files = files;
    }

    public static ClassFiles none() {
        return NONE;
    }

    public static ClassFiles of(ClassFile ... ClassFiles2) {
        return ClassFiles.none().and(ClassFiles2);
    }

    public ClassFiles and(ClassFile ... classFiles) {
        LinkedHashMap<String, ClassFile> merged = new LinkedHashMap<String, ClassFile>(this.files);
        Arrays.stream(classFiles).forEach(file -> merged.put(file.getName(), (ClassFile)file));
        return new ClassFiles(Collections.unmodifiableMap(merged));
    }

    public ClassFiles and(Iterable<ClassFile> classFiles) {
        LinkedHashMap<String, ClassFile> merged = new LinkedHashMap<String, ClassFile>(this.files);
        classFiles.forEach(file -> merged.put(file.getName(), (ClassFile)file));
        return new ClassFiles(Collections.unmodifiableMap(merged));
    }

    @Override
    public Iterator<ClassFile> iterator() {
        return this.files.values().iterator();
    }

    public Stream<ClassFile> stream() {
        return this.files.values().stream();
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Nullable
    public ClassFile get(String name) {
        return this.files.get(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ClassFiles)) return false;
        ClassFiles that = (ClassFiles)other;
        if (!this.files.equals(that.files)) return false;
        return true;
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public String toString() {
        return this.files.toString();
    }
}

