/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Function;
import org.springframework.lang.Nullable;

final class CompileWithForkedClassLoaderClassLoader
extends ClassLoader {
    private final ClassLoader testClassLoader;
    private Function<String, byte[]> classResourceLookup = name -> null;

    public CompileWithForkedClassLoaderClassLoader(ClassLoader testClassLoader) {
        super(testClassLoader.getParent());
        this.testClassLoader = testClassLoader;
    }

    void setClassResourceLookup(Function<String, byte[]> classResourceLookup) {
        this.classResourceLookup = classResourceLookup;
    }

    Class<?> defineDynamicClass(String name, byte[] b, int off, int len) {
        return super.defineClass(name, b, off, len);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.junit") || name.startsWith("org.testng")) {
            return Class.forName(name, false, this.testClassLoader);
        }
        return super.loadClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.findClassBytes(name);
        return bytes != null ? this.defineClass(name, bytes, 0, bytes.length, null) : super.findClass(name);
    }

    @Nullable
    private byte[] findClassBytes(String name) {
        byte[] bytes = this.classResourceLookup.apply(name);
        if (bytes != null) {
            return bytes;
        }
        String resourceName = name.replace(".", "/") + ".class";
        InputStream stream = this.testClassLoader.getResourceAsStream(resourceName);
        if (stream != null) {
            byte[] byArray;
            block10: {
                InputStream inputStream = stream;
                try {
                    byArray = stream.readAllBytes();
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream.close();
            }
            return byArray;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.testClassLoader.getResources(name);
    }

    @Override
    @Nullable
    protected URL findResource(String name) {
        return this.testClassLoader.getResource(name);
    }
}

