/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.test.tools;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AssertProvider;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.test.tools.DynamicFile;
import org.springframework.core.test.tools.ResourceFileAssert;
import org.springframework.core.test.tools.WritableContent;
import org.springframework.util.FileCopyUtils;

public final class ResourceFile
extends DynamicFile
implements AssertProvider<ResourceFileAssert> {
    private ResourceFile(String path, String content) {
        super(path, content);
    }

    public static ResourceFile of(String path, CharSequence charSequence) {
        return new ResourceFile(path, charSequence.toString());
    }

    public static ResourceFile of(String path, byte[] bytes) {
        return new ResourceFile(path, new String(bytes, StandardCharsets.UTF_8));
    }

    public static ResourceFile of(String path, InputStreamSource inputStreamSource) {
        return ResourceFile.of(path, (Appendable appendable) -> appendable.append(FileCopyUtils.copyToString((Reader)new InputStreamReader(inputStreamSource.getInputStream(), StandardCharsets.UTF_8))));
    }

    public static ResourceFile of(String path, WritableContent writableContent) {
        return new ResourceFile(path, ResourceFile.toString(writableContent));
    }

    public ResourceFileAssert assertThat() {
        return new ResourceFileAssert(this);
    }
}

