/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionToMapConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public CollectionToMapConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Collection.class, Map.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection sourceCollection = (Collection)source;
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL) {
            sourceElementType = ConversionUtils.getElementType(sourceCollection);
        }
        TypeDescriptor targetKeyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor targetValueType = targetType.getMapValueTypeDescriptor();
        boolean keysCompatible = false;
        if (sourceElementType != TypeDescriptor.NULL && sourceElementType.isAssignableTo(targetKeyType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (sourceElementType != TypeDescriptor.NULL && sourceElementType.isAssignableTo(targetValueType)) {
            valuesCompatible = true;
        }
        if (keysCompatible && valuesCompatible) {
            Map target = CollectionFactory.createMap(targetType.getType(), sourceCollection.size());
            if (sourceElementType.typeEquals(String.class)) {
                for (Object element : sourceCollection) {
                    String[] property = this.parseProperty((String)element);
                    target.put(property[0], property[1]);
                }
            } else {
                for (Object element : sourceCollection) {
                    target.put(element, element);
                }
            }
            return target;
        }
        Map target = CollectionFactory.createMap(targetType.getType(), sourceCollection.size());
        MapEntryConverter converter = new MapEntryConverter(sourceElementType, sourceElementType, targetKeyType, targetValueType, keysCompatible, valuesCompatible, this.conversionService);
        if (sourceElementType.typeEquals(String.class)) {
            for (Object element : sourceCollection) {
                String[] property = this.parseProperty((String)element);
                Object targetKey = converter.convertKey(property[0]);
                Object targetValue = converter.convertValue(property[1]);
                target.put(targetKey, targetValue);
            }
        } else {
            for (Object element : sourceCollection) {
                Object targetKey = converter.convertKey(element);
                Object targetValue = converter.convertValue(element);
                target.put(targetKey, targetValue);
            }
        }
        return target;
    }

    private String[] parseProperty(String string) {
        String[] property = string.split("=");
        if (property.length < 2) {
            throw new IllegalArgumentException("Invalid String property '" + string + "'; properties should be in the format name=value");
        }
        return property;
    }
}

