/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.CollectionToArrayConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapToCollectionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapToArrayConverter
implements GenericConverter {
    private final GenericConverter mapToCollectionHelperConverter;
    private final GenericConverter collectionToArrayHelperConverter;

    public MapToArrayConverter(GenericConversionService conversionService) {
        this.mapToCollectionHelperConverter = new MapToCollectionConverter(conversionService);
        this.collectionToArrayHelperConverter = new CollectionToArrayConverter(conversionService);
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Map.class, Object[].class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        TypeDescriptor collectionType = TypeDescriptor.collection(List.class, targetType.getElementTypeDescriptor());
        Object collection = this.mapToCollectionHelperConverter.convert(source, sourceType, collectionType);
        return this.collectionToArrayHelperConverter.convert(collection, collectionType, targetType);
    }
}

