/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapToCollectionConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public MapToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Map.class, Collection.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Map sourceMap = (Map)source;
        TypeDescriptor sourceKeyType = sourceType.getMapKeyTypeDescriptor();
        TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
        if (sourceKeyType == TypeDescriptor.NULL || sourceValueType == TypeDescriptor.NULL) {
            TypeDescriptor[] sourceEntryTypes = ConversionUtils.getMapEntryTypes(sourceMap);
            sourceKeyType = sourceEntryTypes[0];
            sourceValueType = sourceEntryTypes[1];
        }
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        boolean keysCompatible = false;
        if (sourceKeyType != TypeDescriptor.NULL && sourceKeyType.isAssignableTo(targetElementType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (sourceValueType != TypeDescriptor.NULL || sourceValueType.isAssignableTo(targetElementType)) {
            valuesCompatible = true;
        }
        Collection target = CollectionFactory.createCollection(targetType.getType(), sourceMap.size());
        MapEntryConverter converter = new MapEntryConverter(sourceKeyType, sourceValueType, targetElementType, targetElementType, keysCompatible, valuesCompatible, this.conversionService);
        if (targetElementType.getType().equals(String.class)) {
            Iterator iterator = sourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = iterator.next();
                String property = converter.convertKey(mapEntry.getKey()) + "=" + converter.convertValue(mapEntry.getValue());
                target.add(property);
            }
        } else {
            for (Object value : sourceMap.values()) {
                target.add(converter.convertValue(value));
            }
        }
        return target;
    }
}

