/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToCollectionConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public ObjectToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Object.class, Collection.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (sourceType.typeEquals(String.class)) {
            String string = (String)source;
            String[] fields = StringUtils.commaDelimitedListToStringArray(string);
            Collection target = CollectionFactory.createCollection(targetType.getType(), fields.length);
            if (targetElementType == TypeDescriptor.NULL || sourceType.isAssignableTo(targetElementType)) {
                int i = 0;
                while (i < fields.length) {
                    target.add(fields[i]);
                    ++i;
                }
            } else {
                GenericConverter converter = this.conversionService.getConverter(sourceType, targetElementType);
                if (converter == null) {
                    throw new ConverterNotFoundException(sourceType, targetElementType);
                }
                int i = 0;
                while (i < fields.length) {
                    String sourceElement = fields[i];
                    Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceType, targetElementType);
                    target.add(targetElement);
                    ++i;
                }
            }
            return target;
        }
        Collection target = CollectionFactory.createCollection(targetType.getType(), 1);
        if (targetElementType == TypeDescriptor.NULL || sourceType.isAssignableTo(targetElementType)) {
            target.add(source);
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceType, targetElementType);
            }
            target.add(ConversionUtils.invokeConverter(converter, source, sourceType, targetElementType));
        }
        return target;
    }
}

