/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToMapConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public ObjectToMapConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Object.class, Map.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        if (sourceType.typeEquals(String.class)) {
            String string = (String)source;
            return this.conversionService.convert(this.loadProperties(string), TypeDescriptor.valueOf(Properties.class), targetType);
        }
        Map target = CollectionFactory.createMap(targetType.getType(), 1);
        TypeDescriptor targetKeyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor targetValueType = targetType.getMapValueTypeDescriptor();
        boolean keysCompatible = false;
        if (sourceType != TypeDescriptor.NULL && sourceType.isAssignableTo(targetKeyType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (sourceType != TypeDescriptor.NULL && sourceType.isAssignableTo(targetValueType)) {
            valuesCompatible = true;
        }
        if (keysCompatible && valuesCompatible) {
            target.put(source, source);
        } else {
            MapEntryConverter converter = new MapEntryConverter(sourceType, sourceType, targetKeyType, targetValueType, keysCompatible, valuesCompatible, this.conversionService);
            Object key = converter.convertKey(source);
            Object value = converter.convertValue(source);
            target.put(key, value);
        }
        return target;
    }

    private Properties loadProperties(String string) {
        try {
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
            return props;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse [" + string + "] into Properties", e);
        }
    }
}

