/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.VfsUtils;
import org.springframework.util.ResourceUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url.getProtocol().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(url).getFile();
        }
        return ResourceUtils.getFile(url, this.getDescription());
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(url);
            if (actualUrl.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(actualUrl).getFile();
            }
            return ResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        if (uri.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uri).getFile();
        }
        return ResourceUtils.getFile(uri, this.getDescription());
    }

    public boolean exists() {
        try {
            boolean doesExist;
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).setRequestMethod("HEAD");
            }
            boolean bl = doesExist = con.getContentLength() >= 0;
            if (!doesExist && con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            return doesExist;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReadable() {
        try {
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url)) {
            return super.contentLength();
        }
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLength();
    }

    public long lastModified() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url) || ResourceUtils.isJarURL(url)) {
            return super.lastModified();
        }
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getLastModified();
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VfsUtils.getRoot(url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uri));
        }
    }
}

