/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.OrderUtils;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    protected int getOrder(Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).getOrder();
        }
        if (obj != null) {
            Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            return OrderUtils.getOrder(clazz, Integer.MAX_VALUE);
        }
        return Integer.MAX_VALUE;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            Collections.sort(list, INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value) {
        if (value instanceof Object[]) {
            AnnotationAwareOrderComparator.sort((Object[])value);
        } else if (value instanceof List) {
            AnnotationAwareOrderComparator.sort((List)value);
        }
    }
}

