/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.OrderProvider;
import org.springframework.core.annotation.OrderProviderComparator;

public class DefaultOrderProviderComparator
implements OrderProviderComparator {
    public static final DefaultOrderProviderComparator INSTANCE = new DefaultOrderProviderComparator();

    @Override
    public void sortList(List<?> items, OrderProvider orderProvider) {
        Collections.sort(items, new OrderProviderAwareComparator(orderProvider));
    }

    @Override
    public void sortArray(Object[] items, OrderProvider orderProvider) {
        Arrays.sort(items, new OrderProviderAwareComparator(orderProvider));
    }

    private static class OrderProviderAwareComparator
    extends AnnotationAwareOrderComparator {
        private final OrderProvider orderProvider;

        public OrderProviderAwareComparator(OrderProvider orderProvider) {
            this.orderProvider = orderProvider;
        }

        @Override
        protected int getOrder(Object obj) {
            Integer order = this.orderProvider.getOrder(obj);
            if (order != null) {
                return order;
            }
            return super.getOrder(obj);
        }
    }
}

