/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.annotation.AnnotationAttributeExtractor;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class AbstractAliasAwareAnnotationAttributeExtractor
implements AnnotationAttributeExtractor {
    private final Class<? extends Annotation> annotationType;
    private final AnnotatedElement annotatedElement;
    private final Object source;
    private final Map<String, String> attributeAliasMap;

    AbstractAliasAwareAnnotationAttributeExtractor(Class<? extends Annotation> annotationType, AnnotatedElement annotatedElement, Object source) {
        Assert.notNull(annotationType, "annotationType must not be null");
        Assert.notNull(source, "source must not be null");
        this.annotationType = annotationType;
        this.annotatedElement = annotatedElement;
        this.source = source;
        this.attributeAliasMap = AnnotationUtils.getAttributeAliasMap(annotationType);
    }

    @Override
    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public final AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public final Object getAttributeValue(Method attributeMethod) {
        String attributeName = attributeMethod.getName();
        Object attributeValue = this.getRawAttributeValue(attributeMethod);
        String aliasName = this.attributeAliasMap.get(attributeName);
        if (aliasName != null) {
            Object aliasValue = this.getRawAttributeValue(aliasName);
            Object defaultValue = AnnotationUtils.getDefaultValue(this.getAnnotationType(), attributeName);
            if (!(AbstractAliasAwareAnnotationAttributeExtractor.nullSafeEquals(attributeValue, aliasValue) || AbstractAliasAwareAnnotationAttributeExtractor.nullSafeEquals(attributeValue, defaultValue) || AbstractAliasAwareAnnotationAttributeExtractor.nullSafeEquals(aliasValue, defaultValue))) {
                String elementName = this.getAnnotatedElement() == null ? "unknown element" : this.getAnnotatedElement().toString();
                String msg = String.format("In annotation [%s] declared on [%s] and synthesized from [%s], attribute [%s] and its alias [%s] are present with values of [%s] and [%s], but only one is permitted.", this.getAnnotationType().getName(), elementName, this.getSource(), attributeName, aliasName, AbstractAliasAwareAnnotationAttributeExtractor.nullSafeToString(attributeValue), AbstractAliasAwareAnnotationAttributeExtractor.nullSafeToString(aliasValue));
                throw new AnnotationConfigurationException(msg);
            }
            if (AbstractAliasAwareAnnotationAttributeExtractor.nullSafeEquals(attributeValue, defaultValue)) {
                attributeValue = aliasValue;
            }
        }
        return attributeValue;
    }

    protected abstract Object getRawAttributeValue(Method var1);

    protected abstract Object getRawAttributeValue(String var1);

    private static boolean nullSafeEquals(Object o1, Object o2) {
        return ObjectUtils.nullSafeEquals(o1, o2);
    }

    private static String nullSafeToString(Object obj) {
        return ObjectUtils.nullSafeToString(obj);
    }
}

