/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AbstractAliasAwareAnnotationAttributeExtractor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

class MapAnnotationAttributeExtractor
extends AbstractAliasAwareAnnotationAttributeExtractor {
    MapAnnotationAttributeExtractor(Map<String, Object> attributes, Class<? extends Annotation> annotationType, AnnotatedElement annotatedElement) {
        super(annotationType, annotatedElement, MapAnnotationAttributeExtractor.enrichAndValidateAttributes(new HashMap<String, Object>(attributes), annotationType));
    }

    @Override
    protected Object getRawAttributeValue(Method attributeMethod) {
        return this.getMap().get(attributeMethod.getName());
    }

    @Override
    protected Object getRawAttributeValue(String attributeName) {
        return this.getMap().get(attributeName);
    }

    private Map<String, Object> getMap() {
        return (Map)this.getSource();
    }

    private static Map<String, Object> enrichAndValidateAttributes(Map<String, Object> attributes, Class<? extends Annotation> annotationType) {
        Map<String, String> attributeAliasMap = AnnotationUtils.getAttributeAliasMap(annotationType);
        for (Method attributeMethod : AnnotationUtils.getAttributeMethods(annotationType)) {
            Object defaultValue;
            Object aliasValue;
            String aliasName;
            String attributeName = attributeMethod.getName();
            Object attributeValue = attributes.get(attributeName);
            if (attributeValue == null && (aliasName = attributeAliasMap.get(attributeName)) != null && (aliasValue = attributes.get(aliasName)) != null) {
                attributeValue = aliasValue;
                attributes.put(attributeName, attributeValue);
            }
            if (attributeValue == null && (defaultValue = AnnotationUtils.getDefaultValue(annotationType, attributeName)) != null) {
                attributeValue = defaultValue;
                attributes.put(attributeName, attributeValue);
            }
            if (attributeValue == null) {
                throw new IllegalArgumentException(String.format("Attributes map [%s] returned null for required attribute [%s] defined by annotation type [%s].", attributes, attributeName, annotationType.getName()));
            }
            Class<?> returnType = attributeMethod.getReturnType();
            if (ClassUtils.isAssignable(returnType, attributeValue.getClass())) continue;
            throw new IllegalArgumentException(String.format("Attributes map [%s] returned a value of type [%s] for attribute [%s], but a value of type [%s] is required as defined by annotation type [%s].", attributes, attributeValue.getClass().getName(), attributeName, returnType.getName(), annotationType.getName()));
        }
        return attributes;
    }
}

