/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.util.ClassUtils;
import reactor.adapter.RxJava1Adapter;
import reactor.adapter.RxJava2Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Completable;
import rx.Observable;

public class ReactiveAdapterRegistry {
    private static final boolean rxJava1Present = ClassUtils.isPresent("rx.Observable", ReactiveAdapterRegistry.class.getClassLoader());
    private static final boolean rxJava2Present = ClassUtils.isPresent("io.reactivex.Flowable", ReactiveAdapterRegistry.class.getClassLoader());
    private final Map<Class<?>, ReactiveAdapter> adapterMap = new LinkedHashMap(4);

    public ReactiveAdapterRegistry() {
        this.registerMonoAdapter(Mono.class, source -> (Mono)source, source -> source, new ReactiveAdapter.Descriptor(false, true, false));
        this.registerFluxAdapter(Flux.class, source -> (Flux)source, source -> source);
        this.registerFluxAdapter(Publisher.class, source -> Flux.from((Publisher)((Publisher)source)), source -> source);
        this.registerMonoAdapter(CompletableFuture.class, source -> Mono.fromFuture((CompletableFuture)((CompletableFuture)source)), Mono::toFuture, new ReactiveAdapter.Descriptor(false, true, false));
        if (rxJava1Present) {
            new RxJava1AdapterRegistrar().register(this);
        }
        if (rxJava2Present) {
            new RxJava2AdapterRegistrar().register(this);
        }
    }

    public void registerMonoAdapter(Class<?> adapteeType, Function<Object, Mono<?>> toAdapter, Function<Mono<?>, Object> fromAdapter, ReactiveAdapter.Descriptor descriptor) {
        this.adapterMap.put(adapteeType, new MonoReactiveAdapter(toAdapter, fromAdapter, descriptor));
    }

    public void registerFluxAdapter(Class<?> adapteeType, Function<Object, Flux<?>> toAdapter, Function<Flux<?>, Object> fromAdapter) {
        this.adapterMap.put(adapteeType, new FluxReactiveAdapter(toAdapter, fromAdapter));
    }

    public ReactiveAdapter getAdapterFrom(Class<?> adapteeType) {
        return this.getAdapterFrom(adapteeType, null);
    }

    public ReactiveAdapter getAdapterFrom(Class<?> adapteeType, Object adaptee) {
        Class<?> actualType = ReactiveAdapterRegistry.getActualType(adapteeType, adaptee);
        return this.getAdapterInternal(supportedType -> supportedType.isAssignableFrom(actualType));
    }

    public ReactiveAdapter getAdapterTo(Class<?> adapteeType) {
        return this.getAdapterTo(adapteeType, null);
    }

    public ReactiveAdapter getAdapterTo(Class<?> adapteeType, Object adaptee) {
        Class<?> actualType = ReactiveAdapterRegistry.getActualType(adapteeType, adaptee);
        return this.getAdapterInternal(supportedType -> supportedType.equals(actualType));
    }

    private ReactiveAdapter getAdapterInternal(Predicate<Class<?>> adapteeTypePredicate) {
        return this.adapterMap.keySet().stream().filter(adapteeTypePredicate).map(this.adapterMap::get).findFirst().orElse(null);
    }

    private static Class<?> getActualType(Class<?> adapteeType, Object adaptee) {
        return (adaptee = ReactiveAdapterRegistry.unwrapOptional(adaptee)) != null ? adaptee.getClass() : adapteeType;
    }

    private static Object unwrapOptional(Object value) {
        return value instanceof Optional ? ((Optional)value).orElse(null) : value;
    }

    private static class RxJava2AdapterRegistrar {
        private RxJava2AdapterRegistrar() {
        }

        public void register(ReactiveAdapterRegistry registry) {
            registry.registerFluxAdapter(Flowable.class, source -> RxJava2Adapter.flowableToFlux((Flowable)((Flowable)source)), RxJava2Adapter::fluxToFlowable);
            registry.registerFluxAdapter(io.reactivex.Observable.class, source -> RxJava2Adapter.observableToFlux((io.reactivex.Observable)((io.reactivex.Observable)source), (BackpressureStrategy)BackpressureStrategy.BUFFER), RxJava2Adapter::fluxToObservable);
            registry.registerMonoAdapter(Single.class, source -> RxJava2Adapter.singleToMono((Single)((Single)source)), RxJava2Adapter::monoToSingle, new ReactiveAdapter.Descriptor(false, false, false));
            registry.registerMonoAdapter(io.reactivex.Completable.class, source -> RxJava2Adapter.completableToMono((io.reactivex.Completable)((io.reactivex.Completable)source)), RxJava2Adapter::monoToCompletable, new ReactiveAdapter.Descriptor(false, true, true));
        }
    }

    private static class RxJava1AdapterRegistrar {
        private RxJava1AdapterRegistrar() {
        }

        public void register(ReactiveAdapterRegistry registry) {
            registry.registerFluxAdapter(Observable.class, source -> RxJava1Adapter.observableToFlux((Observable)((Observable)source)), RxJava1Adapter::publisherToObservable);
            registry.registerMonoAdapter(rx.Single.class, source -> RxJava1Adapter.singleToMono((rx.Single)((rx.Single)source)), RxJava1Adapter::publisherToSingle, new ReactiveAdapter.Descriptor(false, false, false));
            registry.registerMonoAdapter(Completable.class, source -> RxJava1Adapter.completableToMono((Completable)((Completable)source)), RxJava1Adapter::publisherToCompletable, new ReactiveAdapter.Descriptor(false, true, true));
        }
    }

    private static class FluxReactiveAdapter
    implements ReactiveAdapter {
        private final Function<Object, Flux<?>> toAdapter;
        private final Function<Flux<?>, Object> fromAdapter;
        private final ReactiveAdapter.Descriptor descriptor = new ReactiveAdapter.Descriptor(true, true, false);

        FluxReactiveAdapter(Function<Object, Flux<?>> to, Function<Flux<?>, Object> from) {
            this.toAdapter = to;
            this.fromAdapter = from;
        }

        @Override
        public ReactiveAdapter.Descriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public <T> Mono<T> toMono(Object source) {
            if ((source = ReactiveAdapterRegistry.unwrapOptional(source)) == null) {
                return Mono.empty();
            }
            return this.toAdapter.apply(source).next();
        }

        @Override
        public <T> Flux<T> toFlux(Object source) {
            if ((source = ReactiveAdapterRegistry.unwrapOptional(source)) == null) {
                return Flux.empty();
            }
            return this.toAdapter.apply(source);
        }

        @Override
        public <T> Publisher<T> toPublisher(Object source) {
            return this.toFlux(source);
        }

        @Override
        public Object fromPublisher(Publisher<?> source) {
            return source != null ? this.fromAdapter.apply((Flux)source) : null;
        }
    }

    private static class MonoReactiveAdapter
    implements ReactiveAdapter {
        private final Function<Object, Mono<?>> toAdapter;
        private final Function<Mono<?>, Object> fromAdapter;
        private final ReactiveAdapter.Descriptor descriptor;

        MonoReactiveAdapter(Function<Object, Mono<?>> to, Function<Mono<?>, Object> from, ReactiveAdapter.Descriptor descriptor) {
            this.toAdapter = to;
            this.fromAdapter = from;
            this.descriptor = descriptor;
        }

        @Override
        public ReactiveAdapter.Descriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public <T> Mono<T> toMono(Object source) {
            if ((source = ReactiveAdapterRegistry.unwrapOptional(source)) == null) {
                return Mono.empty();
            }
            return this.toAdapter.apply(source);
        }

        @Override
        public <T> Flux<T> toFlux(Object source) {
            if ((source = ReactiveAdapterRegistry.unwrapOptional(source)) == null) {
                return Flux.empty();
            }
            return this.toMono(source).flux();
        }

        @Override
        public <T> Publisher<T> toPublisher(Object source) {
            return this.toMono(source);
        }

        @Override
        public Object fromPublisher(Publisher<?> source) {
            return source != null ? this.fromAdapter.apply((Mono)source) : null;
        }
    }
}

