/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public class CharSequenceEncoder
extends AbstractEncoder<CharSequence> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public CharSequenceEncoder() {
        super(new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    @Override
    public boolean canEncode(ResolvableType elementType, MimeType mimeType) {
        Class<?> clazz = elementType.getRawClass();
        return super.canEncode(elementType, mimeType) && CharSequence.class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends CharSequence> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        Charset charset = mimeType != null && mimeType.getCharset() != null ? mimeType.getCharset() : DEFAULT_CHARSET;
        return Flux.from(inputStream).map(charSequence -> {
            CharBuffer charBuffer = CharBuffer.wrap(charSequence);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            return bufferFactory.wrap(byteBuffer);
        });
    }
}

