/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.retry;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.DefaultRetryPolicy;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;
import org.springframework.util.backoff.FixedBackOff;

public interface RetryPolicy {
    public boolean shouldRetry(Throwable var1);

    default public BackOff getBackOff() {
        return new FixedBackOff(1000L, 3L);
    }

    public static RetryPolicy withDefaults() {
        return throwable -> true;
    }

    public static RetryPolicy withMaxAttempts(long maxAttempts) {
        Assert.isTrue(maxAttempts > 0L, "Max attempts must be greater than zero");
        return RetryPolicy.builder().backOff(new FixedBackOff(1000L, maxAttempts)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public static final long DEFAULT_MAX_ATTEMPTS = 3L;
        public static final long DEFAULT_DELAY = 1000L;
        public static final long DEFAULT_MAX_DELAY = Long.MAX_VALUE;
        public static final double DEFAULT_MULTIPLIER = 1.0;
        private @Nullable BackOff backOff;
        private long maxAttempts;
        private @Nullable Duration delay;
        private @Nullable Duration jitter;
        private double multiplier;
        private @Nullable Duration maxDelay;
        private final Set<Class<? extends Throwable>> includes = new LinkedHashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> excludes = new LinkedHashSet<Class<? extends Throwable>>();
        private @Nullable Predicate<Throwable> predicate;

        private Builder() {
        }

        public Builder backOff(BackOff backOff) {
            Assert.notNull((Object)backOff, "BackOff must not be null");
            this.backOff = backOff;
            return this;
        }

        public Builder maxAttempts(long maxAttempts) {
            Assert.isTrue(maxAttempts > 0L, "Max attempts must be greater than zero");
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delay(Duration delay) {
            Assert.isTrue(!delay.isNegative(), () -> "Invalid delay (%dms): must be >= 0.".formatted(delay.toMillis()));
            this.delay = delay;
            return this;
        }

        public Builder jitter(Duration jitter) {
            Assert.isTrue(!jitter.isNegative(), () -> "Invalid jitter (%dms): must be >= 0.".formatted(jitter.toMillis()));
            this.jitter = jitter;
            return this;
        }

        public Builder multiplier(double multiplier) {
            Assert.isTrue(multiplier >= 1.0, () -> "Invalid multiplier '" + multiplier + "': must be greater than or equal to 1. A multiplier of 1 is equivalent to a fixed delay.");
            this.multiplier = multiplier;
            return this;
        }

        public Builder maxDelay(Duration maxDelay) {
            Builder.assertIsPositive("maxDelay", maxDelay);
            this.maxDelay = maxDelay;
            return this;
        }

        @SafeVarargs
        public final Builder includes(Class<? extends Throwable> ... types) {
            Collections.addAll(this.includes, types);
            return this;
        }

        public Builder includes(Collection<Class<? extends Throwable>> types) {
            this.includes.addAll(types);
            return this;
        }

        @SafeVarargs
        public final Builder excludes(Class<? extends Throwable> ... types) {
            Collections.addAll(this.excludes, types);
            return this;
        }

        public Builder excludes(Collection<Class<? extends Throwable>> types) {
            this.excludes.addAll(types);
            return this;
        }

        public Builder predicate(Predicate<Throwable> predicate) {
            this.predicate = this.predicate != null ? this.predicate.and(predicate) : predicate;
            return this;
        }

        public RetryPolicy build() {
            BackOff backOff = this.backOff;
            if (backOff != null) {
                boolean misconfigured = this.maxAttempts != 0L || this.delay != null || this.jitter != null || this.multiplier != 0.0 || this.maxDelay != null;
                Assert.state(!misconfigured, "The following configuration options are not supported with a custom BackOff strategy: maxAttempts, delay, jitter, multiplier, or maxDelay.");
            } else {
                ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
                exponentialBackOff.setMaxAttempts(this.maxAttempts > 0L ? this.maxAttempts : 3L);
                exponentialBackOff.setInitialInterval(this.delay != null ? this.delay.toMillis() : 1000L);
                exponentialBackOff.setMaxInterval(this.maxDelay != null ? this.maxDelay.toMillis() : Long.MAX_VALUE);
                exponentialBackOff.setMultiplier(this.multiplier > 1.0 ? this.multiplier : 1.0);
                if (this.jitter != null) {
                    exponentialBackOff.setJitter(this.jitter.toMillis());
                }
                backOff = exponentialBackOff;
            }
            return new DefaultRetryPolicy(this.includes, this.excludes, this.predicate, backOff);
        }

        private static void assertIsPositive(String name, Duration duration) {
            Assert.isTrue(!duration.isNegative() && !duration.isZero(), () -> "Invalid duration (%dms): %s must be positive.".formatted(duration.toMillis(), name));
        }
    }
}

