/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.core.task.VirtualThreadDelegate;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrencyThrottleSupport;
import org.springframework.util.CustomizableThreadCreator;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncTaskExecutor,
Serializable,
AutoCloseable {
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    private @Nullable VirtualThreadDelegate virtualThreadDelegate;
    private @Nullable ThreadFactory threadFactory;
    private @Nullable TaskDecorator taskDecorator;
    private long taskTerminationTimeout;
    private @Nullable Set<Thread> activeThreads;
    private boolean rejectTasksWhenLimitReached = false;
    private volatile boolean active = true;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public SimpleAsyncTaskExecutor(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setVirtualThreads(boolean virtual) {
        this.virtualThreadDelegate = virtual ? new VirtualThreadDelegate() : null;
    }

    public void setThreadFactory(@Nullable ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public final @Nullable ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setTaskTerminationTimeout(long timeout) {
        Assert.isTrue(timeout >= 0L, "Timeout value must be >=0");
        this.taskTerminationTimeout = timeout;
        this.activeThreads = timeout > 0L ? ConcurrentHashMap.newKeySet() : null;
    }

    public void setRejectTasksWhenLimitReached(boolean rejectTasksWhenLimitReached) {
        this.rejectTasksWhenLimitReached = rejectTasksWhenLimitReached;
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public final int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public final boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void execute(Runnable task) {
        this.execute(task, Long.MAX_VALUE);
    }

    @Override
    @Deprecated(since="5.3.16")
    public void execute(Runnable task, long startTimeout) {
        Runnable taskToUse;
        Assert.notNull((Object)task, "Runnable must not be null");
        if (!this.isActive()) {
            throw new TaskRejectedException(this.getClass().getSimpleName() + " has been closed already");
        }
        Runnable runnable = taskToUse = this.taskDecorator != null ? this.taskDecorator.decorate(task) : task;
        if (this.isThrottleActive() && startTimeout > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else if (this.activeThreads != null) {
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else {
            this.doExecute(taskToUse);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    protected void doExecute(Runnable task) {
        this.newThread(task).start();
    }

    protected Thread newThread(Runnable task) {
        if (this.virtualThreadDelegate != null) {
            return this.virtualThreadDelegate.newVirtualThread(this.nextThreadName(), task);
        }
        return this.threadFactory != null ? this.threadFactory.newThread(task) : this.createThread(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.active) {
            this.active = false;
            Set<Thread> threads = this.activeThreads;
            if (threads != null) {
                Set<Thread> set = threads;
                synchronized (set) {
                    try {
                        if (!threads.isEmpty()) {
                            threads.wait(this.taskTerminationTimeout);
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                threads.forEach(Thread::interrupt);
            }
        }
    }

    private class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        @Override
        protected void beforeAccess() {
            super.beforeAccess();
        }

        @Override
        protected void onLimitReached() {
            if (SimpleAsyncTaskExecutor.this.rejectTasksWhenLimitReached) {
                throw new TaskRejectedException("Concurrency limit reached: " + this.getConcurrencyLimit());
            }
            super.onLimitReached();
        }

        @Override
        protected void afterAccess() {
            super.afterAccess();
        }
    }

    private class TaskTrackingRunnable
    implements Runnable {
        private final Runnable task;

        public TaskTrackingRunnable(Runnable task) {
            Assert.notNull((Object)task, "Task must not be null");
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<Thread> threads = SimpleAsyncTaskExecutor.this.activeThreads;
            Thread thread = null;
            if (threads != null) {
                thread = Thread.currentThread();
                threads.add(thread);
            }
            try {
                this.task.run();
            }
            finally {
                if (threads != null) {
                    threads.remove(thread);
                    if (!SimpleAsyncTaskExecutor.this.isActive()) {
                        Set<Thread> set = threads;
                        synchronized (set) {
                            if (threads.isEmpty()) {
                                threads.notify();
                            }
                        }
                    }
                }
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }
}

