/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.function;

import java.util.function.BiFunction;
import java.util.function.Supplier;

public interface ThrowingSupplier<T>
extends Supplier<T> {
    public T getWithException() throws Exception;

    @Override
    default public T get() {
        return this.get(RuntimeException::new);
    }

    default public T get(BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            return this.getWithException();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw exceptionWrapper.apply(ex.getMessage(), ex);
        }
    }

    default public ThrowingSupplier<T> throwing(final BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return new ThrowingSupplier<T>(this){
            final /* synthetic */ ThrowingSupplier this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T getWithException() throws Exception {
                return this.this$0.getWithException();
            }

            @Override
            public T get() {
                return this.get(exceptionWrapper);
            }
        };
    }

    public static <T> ThrowingSupplier<T> of(ThrowingSupplier<T> supplier) {
        return supplier;
    }

    public static <T> ThrowingSupplier<T> of(ThrowingSupplier<T> supplier, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return supplier.throwing(exceptionWrapper);
    }
}

