/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CompositeCollection;
import org.springframework.util.CompositeSet;
import org.springframework.util.FilteredMap;

final class CompositeMap<K, V>
implements Map<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;
    private final @Nullable BiFunction<K, V, V> putFunction;
    private final @Nullable Consumer<Map<K, V>> putAllFunction;

    CompositeMap(Map<K, V> first, Map<K, V> second) {
        this(first, second, null, null);
    }

    CompositeMap(Map<K, V> first, Map<K, V> second, @Nullable BiFunction<K, V, V> putFunction, @Nullable Consumer<Map<K, V>> putAllFunction) {
        Assert.notNull(first, "First must not be null");
        Assert.notNull(second, "Second must not be null");
        this.first = first;
        this.second = new FilteredMap<Object, V>(second, key -> !this.first.containsKey(key));
        this.putFunction = putFunction;
        this.putAllFunction = putAllFunction;
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.first.containsKey(key)) {
            return true;
        }
        return this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.first.containsValue(value)) {
            return true;
        }
        return this.second.containsValue(value);
    }

    @Override
    public @Nullable V get(Object key) {
        V firstResult = this.first.get(key);
        if (firstResult != null) {
            return firstResult;
        }
        return this.second.get(key);
    }

    @Override
    public @Nullable V put(K key, V value) {
        if (this.putFunction == null) {
            throw new UnsupportedOperationException();
        }
        return this.putFunction.apply(key, value);
    }

    @Override
    public @Nullable V remove(Object key) {
        V firstResult = this.first.remove(key);
        V secondResult = this.second.remove(key);
        if (firstResult != null) {
            return firstResult;
        }
        return secondResult;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.putAllFunction != null) {
            this.putAllFunction.accept(m);
        } else {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.first.clear();
        this.second.clear();
    }

    @Override
    public Set<K> keySet() {
        return new CompositeSet<K>(this.first.keySet(), this.second.keySet());
    }

    @Override
    public Collection<V> values() {
        return new CompositeCollection<V>(this.first.values(), this.second.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new CompositeSet<Map.Entry<K, V>>(this.first.entrySet(), this.second.entrySet());
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

