/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ClassUtils;

public abstract class TransactionAspectSupport
implements InitializingBean {
    private static ThreadLocal currentTransactionInfo = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;

    public static TransactionStatus currentTransactionStatus() throws NoTransactionException {
        return TransactionAspectSupport.currentTransactionInfo().transactionStatus;
    }

    protected static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        TransactionInfo info = (TransactionInfo)currentTransactionInfo.get();
        if (info == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("transactionManager is required");
        }
        if (this.transactionAttributeSource == null) {
            throw new IllegalArgumentException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, don't use a TransactionInterceptor or TransactionProxyFactoryBean.");
        }
    }

    protected TransactionInfo createTransactionIfNecessary(Method method, Class targetClass) {
        TransactionAttribute sourceAttr = this.transactionAttributeSource.getTransactionAttribute(method, targetClass);
        TransactionAttribute txAttr = sourceAttr;
        if (txAttr != null && txAttr.getName() == null) {
            final String name = this.methodIdentification(method);
            txAttr = new DelegatingTransactionAttribute(sourceAttr){

                public String getName() {
                    return name;
                }
            };
        }
        TransactionInfo txInfo = new TransactionInfo(txAttr, method);
        if (txAttr != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting transaction for " + txInfo.joinpointIdentification()));
            }
            txInfo.newTransactionStatus(this.transactionManager.getTransaction(txAttr));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Don't need to create transaction for [" + this.methodIdentification(method) + "]: this method isn't transactional"));
        }
        txInfo.bindToThread();
        return txInfo;
    }

    protected String methodIdentification(Method method) {
        return ClassUtils.getQualifiedMethodName((Method)method);
    }

    protected void doCommitTransactionAfterReturning(TransactionInfo txInfo) {
        if (txInfo != null && txInfo.hasTransaction()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking commit for transaction on " + txInfo.joinpointIdentification()));
            }
            this.transactionManager.commit(txInfo.getTransactionStatus());
        }
    }

    protected void doCloseTransactionAfterThrowing(TransactionInfo txInfo, Throwable ex) {
        if (txInfo.hasTransaction()) {
            if (txInfo.transactionAttribute.rollbackOn(ex)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking rollback for transaction on " + txInfo.joinpointIdentification() + " due to throwable [" + ex + "]"));
                }
                try {
                    this.transactionManager.rollback(txInfo.getTransactionStatus());
                }
                catch (RuntimeException ex2) {
                    this.logger.error((Object)"Application exception overridden by rollback exception", ex);
                    throw ex2;
                }
                catch (Error err) {
                    this.logger.error((Object)"Application exception overridden by rollback error", ex);
                    throw err;
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(txInfo.joinpointIdentification() + " threw throwable [" + ex + "] but this does not force transaction rollback"));
                }
                this.transactionManager.commit(txInfo.getTransactionStatus());
            }
        }
    }

    protected void doFinally(TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    protected class TransactionInfo {
        private final TransactionAttribute transactionAttribute;
        private final Method method;
        private TransactionStatus transactionStatus;
        private TransactionInfo oldTransactionInfo;

        public TransactionInfo(TransactionAttribute transactionAttribute, Method method) {
            this.transactionAttribute = transactionAttribute;
            this.method = method;
        }

        public boolean hasTransaction() {
            return this.transactionStatus != null;
        }

        public String joinpointIdentification() {
            return TransactionAspectSupport.this.methodIdentification(this.method);
        }

        public void newTransactionStatus(TransactionStatus status) {
            this.transactionStatus = status;
        }

        private void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)currentTransactionInfo.get();
            currentTransactionInfo.set(this);
        }

        private void restoreThreadLocalStatus() {
            currentTransactionInfo.set(this.oldTransactionInfo);
        }

        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public TransactionAttribute getTransactionAttribute() {
            return this.transactionAttribute;
        }
    }
}

