/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.tomcat;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.loader.WebappClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;

public class TomcatInstrumentableClassLoader
extends WebappClassLoader {
    private static final String CLASS_SUFFIX = ".class";
    private final WeavingTransformer weavingTransformer = new WeavingTransformer((ClassLoader)((Object)this));

    public TomcatInstrumentableClassLoader() {
    }

    public TomcatInstrumentableClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    public ClassLoader getThrowawayClassLoader() {
        WebappClassLoader tempLoader = new WebappClassLoader();
        TomcatInstrumentableClassLoader.shallowCopyFieldState(this, tempLoader);
        return tempLoader;
    }

    protected ResourceEntry findResourceInternal(String name, String path) {
        ResourceEntry entry = super.findResourceInternal(name, path);
        if (entry != null && entry.binaryContent != null && path.endsWith(CLASS_SUFFIX)) {
            String className = name.endsWith(CLASS_SUFFIX) ? name.substring(0, name.length() - CLASS_SUFFIX.length()) : name;
            entry.binaryContent = this.weavingTransformer.transformIfNecessary(className, entry.binaryContent);
        }
        return entry;
    }

    protected ResourceEntry findResourceInternal(String name, String path, boolean manifestRequired) {
        ResourceEntry entry = super.findResourceInternal(name, path, manifestRequired);
        if (entry != null && entry.binaryContent != null && path.endsWith(CLASS_SUFFIX)) {
            String className = name.endsWith(CLASS_SUFFIX) ? name.substring(0, name.length() - CLASS_SUFFIX.length()) : name;
            entry.binaryContent = this.weavingTransformer.transformIfNecessary(className, entry.binaryContent);
        }
        return entry;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "\r\n" + super.toString();
    }

    private static void shallowCopyFieldState(WebappClassLoader src, WebappClassLoader dest) {
        Class targetClass = WebappClassLoader.class;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.getName().equals("resourceEntries")) continue;
                try {
                    field.setAccessible(true);
                    Object srcValue = field.get(src);
                    field.set(dest, srcValue);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }
}

