/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class requiredType) {
        this.requiredType = requiredType;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            try {
                return this.convertValueToRequiredType(result, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(1) + "': " + ex.getMessage());
            }
        }
        return result;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        if (requiredType != null) {
            Object value = null;
            boolean wasNullCheck = false;
            if (String.class.equals(requiredType)) {
                value = rs.getString(index);
            } else if (Boolean.class.equals(requiredType)) {
                value = rs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
                wasNullCheck = true;
            } else if (Byte.class.equals(requiredType)) {
                value = new Byte(rs.getByte(index));
                wasNullCheck = true;
            } else if (Short.class.equals(requiredType)) {
                value = new Short(rs.getShort(index));
                wasNullCheck = true;
            } else if (Integer.class.equals(requiredType)) {
                value = new Integer(rs.getInt(index));
                wasNullCheck = true;
            } else if (Long.class.equals(requiredType)) {
                value = new Long(rs.getLong(index));
                wasNullCheck = true;
            } else if (Float.class.equals(requiredType)) {
                value = new Float(rs.getFloat(index));
                wasNullCheck = true;
            } else if (Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
                value = new Double(rs.getDouble(index));
                wasNullCheck = true;
            } else {
                value = [B.class.equals(requiredType) ? (Object)rs.getBytes(index) : (Date.class.equals(requiredType) ? rs.getDate(index) : (Time.class.equals(requiredType) ? rs.getTime(index) : (Timestamp.class.equals(requiredType) || java.util.Date.class.equals(requiredType) ? rs.getTimestamp(index) : (BigDecimal.class.equals(requiredType) ? rs.getBigDecimal(index) : (Blob.class.equals(requiredType) ? rs.getBlob(index) : (Clob.class.equals(requiredType) ? rs.getClob(index) : rs.getObject(index)))))));
            }
            if (wasNullCheck && value != null && rs.wasNull()) {
                value = null;
            }
            return value;
        }
        return this.getColumnValue(rs, index);
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

    protected Object convertValueToRequiredType(Object value, Class requiredType) {
        if (String.class.equals(requiredType)) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (value instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)((Number)value), (Class)requiredType);
            }
            return NumberUtils.parseNumber((String)value.toString(), (Class)requiredType);
        }
        throw new IllegalArgumentException("Value [" + value + "] is of type [" + value.getClass().getName() + "] and cannot be converted to required type [" + requiredType.getName() + "]");
    }
}

