/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class AbstractDataSource
implements DataSource {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    public Object unwrap(Class iface) throws SQLException {
        Assert.notNull((Object)iface, (String)"Interface argument must not be null");
        if (!DataSource.class.equals(iface)) {
            throw new SQLException("DataSource of type [" + this.getClass().getName() + "] can only be unwrapped as [javax.sql.DataSource], not as [" + iface.getName());
        }
        return this;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return DataSource.class.equals(iface);
    }
}

