/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JmsResourceHolder
extends ResourceHolderSupport {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jms$connection$JmsResourceHolder == null ? (class$org$springframework$jms$connection$JmsResourceHolder = JmsResourceHolder.class$("org.springframework.jms.connection.JmsResourceHolder")) : class$org$springframework$jms$connection$JmsResourceHolder));
    private final boolean frozen;
    private final List connections = new LinkedList();
    private final List sessions = new LinkedList();
    private final Map sessionsPerConnection = new HashMap();
    static /* synthetic */ Class class$org$springframework$jms$connection$JmsResourceHolder;

    public JmsResourceHolder() {
        this.frozen = false;
    }

    public JmsResourceHolder(Connection connection, Session session) {
        this.addConnection(connection);
        this.addSession(session, connection);
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void addConnection(Connection connection) {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot add Connection because JmsResourceHolder is frozen");
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public final void addSession(Session session) {
        this.addSession(session, null);
    }

    public final void addSession(Session session, Connection connection) {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"Cannot add Session because JmsResourceHolder is frozen");
        Assert.notNull((Object)session, (String)"Session must not be null");
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            if (connection != null) {
                LinkedList<Session> sessions = (LinkedList<Session>)this.sessionsPerConnection.get(connection);
                if (sessions == null) {
                    sessions = new LinkedList<Session>();
                    this.sessionsPerConnection.put(connection, sessions);
                }
                sessions.add(session);
            }
        }
    }

    public Connection getConnection() {
        return !this.connections.isEmpty() ? (Connection)this.connections.get(0) : null;
    }

    public Connection getConnection(Class connectionType) {
        return (Connection)CollectionUtils.findValueOfType((Collection)this.connections, (Class)connectionType);
    }

    public Session getSession() {
        return !this.sessions.isEmpty() ? (Session)this.sessions.get(0) : null;
    }

    public Session getSession(Class sessionType) {
        return this.getSession(sessionType, null);
    }

    public Session getSession(Class sessionType, Connection connection) {
        List sessions = this.sessions;
        if (connection != null) {
            sessions = (List)this.sessionsPerConnection.get(connection);
        }
        return (Session)CollectionUtils.findValueOfType((Collection)sessions, (Class)sessionType);
    }

    public void commitAll() throws JMSException {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            try {
                ((Session)it.next()).commit();
            }
            catch (TransactionInProgressException ex) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            try {
                ((Session)it.next()).close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close JMS Session after transaction", ex);
            }
        }
        it = this.connections.iterator();
        while (it.hasNext()) {
            try {
                Connection con = (Connection)it.next();
                try {
                    con.stop();
                }
                finally {
                    con.close();
                }
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close JMS Connection after transaction", ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

