/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap;

import java.util.List;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.ldap.AttributesMapper;
import org.springframework.ldap.CollectingNameClassPairCallbackHandler;
import org.springframework.ldap.ContextExecutor;
import org.springframework.ldap.ContextMapper;
import org.springframework.ldap.ContextSource;
import org.springframework.ldap.DefaultNameClassPairMapper;
import org.springframework.ldap.DefaultNamingExceptionTranslator;
import org.springframework.ldap.DirContextProcessor;
import org.springframework.ldap.EntryNotFoundException;
import org.springframework.ldap.LdapOperations;
import org.springframework.ldap.NameClassPairCallbackHandler;
import org.springframework.ldap.NameClassPairMapper;
import org.springframework.ldap.NamingExceptionTranslator;
import org.springframework.ldap.SearchExecutor;
import org.springframework.ldap.support.DirContextAdapter;
import org.springframework.ldap.support.DistinguishedName;

public class LdapTemplate
implements LdapOperations,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$LdapTemplate == null ? (class$org$springframework$ldap$LdapTemplate = LdapTemplate.class$("org.springframework.ldap.LdapTemplate")) : class$org$springframework$ldap$LdapTemplate));
    private static final int DEFAULT_SEARCH_SCOPE = 2;
    private static final boolean DONT_RETURN_OBJ_FLAG = false;
    private static final boolean RETURN_OBJ_FLAG = true;
    private static final String[] ALL_ATTRIBUTES = null;
    private ContextSource contextSource;
    private NamingExceptionTranslator exceptionTranslator = new DefaultNamingExceptionTranslator();
    private boolean ignorePartialResultException = false;
    static /* synthetic */ Class class$org$springframework$ldap$LdapTemplate;

    public LdapTemplate() {
    }

    public LdapTemplate(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ignorePartialResultException = ignore;
    }

    public void search(Name base, String filter, int searchScope, boolean returningObjFlag, NameClassPairCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag, ALL_ATTRIBUTES), handler);
    }

    public void search(String base, String filter, int searchScope, boolean returningObjFlag, NameClassPairCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag, ALL_ATTRIBUTES), handler);
    }

    public void search(final Name base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    public void search(final String base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    public void search(final Name base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler, processor);
    }

    public void search(final String base, final String filter, final SearchControls controls, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler, processor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(SearchExecutor se, NameClassPairCallbackHandler handler, DirContextProcessor processor) {
        DirContext ctx = this.contextSource.getReadOnlyContext();
        NamingEnumeration results = null;
        try {
            processor.preProcess(ctx);
            results = se.executeSearch(ctx);
            while (true) {
                if (!results.hasMore()) {
                    processor.postProcess(ctx);
                    this.closeContextAndNamingEnumeration(ctx, results);
                    return;
                }
                NameClassPair result = (NameClassPair)results.next();
                handler.handleNameClassPair(result);
            }
        }
        catch (NameNotFoundException e) {
            this.closeContextAndNamingEnumeration(ctx, results);
            return;
            catch (PartialResultException e2) {
                if (!this.ignorePartialResultException) throw this.getExceptionTranslator().translate(e2);
                log.debug((Object)"PartialResultException encountered and ignored", (Throwable)e2);
                this.closeContextAndNamingEnumeration(ctx, results);
                return;
                {
                    catch (Throwable throwable) {
                        this.closeContextAndNamingEnumeration(ctx, results);
                        throw throwable;
                    }
                }
                catch (NamingException e3) {
                    throw this.getExceptionTranslator().translate(e3);
                }
            }
        }
    }

    public void search(SearchExecutor se, NameClassPairCallbackHandler handler) {
        this.search(se, handler, new NullDirContextProcessor());
    }

    public void search(Name base, String filter, NameClassPairCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(2, false, ALL_ATTRIBUTES), handler);
    }

    public void search(String base, String filter, NameClassPairCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(2, false, ALL_ATTRIBUTES), handler);
    }

    public List search(Name base, String filter, int searchScope, String[] attrs, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false, attrs), mapper);
    }

    public List search(String base, String filter, int searchScope, String[] attrs, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false, attrs), mapper);
    }

    public List search(Name base, String filter, int searchScope, AttributesMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(String base, String filter, int searchScope, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(Name base, String filter, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(Name base, String filter, int searchScope, String[] attrs, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true, attrs), mapper);
    }

    public List search(String base, String filter, int searchScope, String[] attrs, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true, attrs), mapper);
    }

    public List search(Name base, String filter, int searchScope, ContextMapper mapper) {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(String base, String filter, int searchScope, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, searchScope, ALL_ATTRIBUTES, mapper);
    }

    public List search(Name base, String filter, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, SearchControls controls, ContextMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(Name base, String filter, SearchControls controls, ContextMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(Name base, String filter, SearchControls controls, AttributesMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(String base, String filter, SearchControls controls, AttributesMapper mapper) {
        return this.search(base, filter, controls, mapper, (DirContextProcessor)new NullDirContextProcessor());
    }

    public List search(String base, String filter, SearchControls controls, AttributesMapper mapper, DirContextProcessor processor) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, AttributesMapper mapper, DirContextProcessor processor) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(String base, String filter, SearchControls controls, ContextMapper mapper, DirContextProcessor processor) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, ContextMapper mapper, DirContextProcessor processor) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (NameClassPairCallbackHandler)handler, processor);
        return handler.getList();
    }

    public void list(final String base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.list(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public void list(final Name base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.list(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public List list(String base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.list(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List list(Name base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.list(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List list(Name base) {
        return this.list(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List list(String base) {
        return this.list(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public void listBindings(final String base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.listBindings(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public void listBindings(final Name base, NameClassPairCallbackHandler handler) {
        SearchExecutor searchExecutor = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.listBindings(base);
            }
        };
        this.search(searchExecutor, handler);
    }

    public List listBindings(String base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(Name base, NameClassPairMapper mapper) {
        MappingCollectingNameClassPairCallbackHandler handler = new MappingCollectingNameClassPairCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(String base) {
        return this.listBindings(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List listBindings(Name base) {
        return this.listBindings(base, (NameClassPairMapper)new DefaultNameClassPairMapper());
    }

    public List listBindings(String base, ContextMapper mapper) {
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public List listBindings(Name base, ContextMapper mapper) {
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.listBindings(base, (NameClassPairCallbackHandler)handler);
        return handler.getList();
    }

    public Object executeReadOnly(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadOnlyContext();
        return this.executeWithContext(ce, ctx);
    }

    public Object executeReadWrite(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadWriteContext();
        return this.executeWithContext(ce, ctx);
    }

    private Object executeWithContext(ContextExecutor ce, DirContext ctx) {
        try {
            Object object = ce.executeWithContext(ctx);
            return object;
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
        finally {
            this.closeContext(ctx);
        }
    }

    public Object lookup(final Name dn) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final String dn) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final Name dn, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final String dn, final AttributesMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final Name dn, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public Object lookup(final String dn, final ContextMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public Object lookup(final Name dn, final String[] attributes, final AttributesMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                return mapper.mapFromAttributes(filteredAttributes);
            }
        });
    }

    public Object lookup(final String dn, final String[] attributes, final AttributesMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                return mapper.mapFromAttributes(filteredAttributes);
            }
        });
    }

    public Object lookup(final Name dn, final String[] attributes, final ContextMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                DirContextAdapter contextAdapter = new DirContextAdapter(filteredAttributes, dn);
                return mapper.mapFromContext(contextAdapter);
            }
        });
    }

    public Object lookup(final String dn, final String[] attributes, final ContextMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
                DistinguishedName name = new DistinguishedName(dn);
                DirContextAdapter contextAdapter = new DirContextAdapter(filteredAttributes, name);
                return mapper.mapFromContext(contextAdapter);
            }
        });
    }

    public void modifyAttributes(final Name dn, final ModificationItem[] mods) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void modifyAttributes(final String dn, final ModificationItem[] mods) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void bind(final Name dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void bind(final String dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void unbind(Name dn) {
        this.doUnbind(dn);
    }

    public void unbind(String dn) throws DataAccessException {
        this.doUnbind(dn);
    }

    public void unbind(Name dn, boolean recursive) throws DataAccessException {
        if (!recursive) {
            this.doUnbind(dn);
        } else {
            this.doUnbindRecursively(dn);
        }
    }

    public void unbind(String dn, boolean recursive) throws DataAccessException {
        if (!recursive) {
            this.doUnbind(dn);
        } else {
            this.doUnbindRecursively(dn);
        }
    }

    private void doUnbind(final Name dn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    private void doUnbind(final String dn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    private void doUnbindRecursively(final Name dn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                LdapTemplate.this.deleteRecursively(ctx, new DistinguishedName(dn));
                return null;
            }
        });
    }

    private void doUnbindRecursively(final String dn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                LdapTemplate.this.deleteRecursively(ctx, new DistinguishedName(dn));
                return null;
            }
        });
    }

    protected void deleteRecursively(DirContext ctx, DistinguishedName name) throws DataAccessException {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                DistinguishedName childName = new DistinguishedName(binding.getName());
                childName.prepend(name);
                this.deleteRecursively(ctx, childName);
            }
            ctx.unbind(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + name + " deleted"));
            }
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception e) {}
        }
    }

    public void rebind(final Name dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void rebind(final String dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void rename(final Name oldDn, final Name newDn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rename(oldDn, newDn);
                return null;
            }
        });
    }

    public void rename(final String oldDn, final String newDn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rename(oldDn, newDn);
                return null;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        if (this.contextSource == null) {
            throw new IllegalArgumentException("Property 'contextSource' must be set.");
        }
    }

    private void closeContextAndNamingEnumeration(DirContext ctx, NamingEnumeration results) {
        this.closeNamingEnumeration(results);
        this.closeContext(ctx);
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeNamingEnumeration(NamingEnumeration results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    private SearchControls getDefaultSearchControls(int searchScope, boolean returningObjFlag, String[] attrs) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setReturningObjFlag(returningObjFlag);
        controls.setReturningAttributes(attrs);
        return controls;
    }

    private void assureReturnObjFlagSet(SearchControls controls) {
        Validate.notNull((Object)controls);
        if (!controls.getReturningObjFlag()) {
            log.info((Object)"The returnObjFlag of supplied SearchControls is not set but a ContextMapper is used - setting flag to true");
            controls.setReturningObjFlag(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ContextMapperCallbackHandler
    extends CollectingNameClassPairCallbackHandler {
        private ContextMapper mapper;

        public ContextMapperCallbackHandler(ContextMapper mapper) {
            this.mapper = mapper;
        }

        public Object getObjectFromNameClassPair(NameClassPair nameClassPair) {
            Binding binding = (Binding)nameClassPair;
            Object object = binding.getObject();
            if (object == null) {
                throw new EntryNotFoundException("SearchResult did not contain any object.");
            }
            return this.mapper.mapFromContext(object);
        }
    }

    public class AttributesMapperCallbackHandler
    extends CollectingNameClassPairCallbackHandler {
        private AttributesMapper mapper;

        public AttributesMapperCallbackHandler(AttributesMapper mapper) {
            this.mapper = mapper;
        }

        public Object getObjectFromNameClassPair(NameClassPair nameClassPair) {
            SearchResult searchResult = (SearchResult)nameClassPair;
            Attributes attributes = searchResult.getAttributes();
            try {
                return this.mapper.mapFromAttributes(attributes);
            }
            catch (NamingException e) {
                throw LdapTemplate.this.getExceptionTranslator().translate(e);
            }
        }
    }

    public class MappingCollectingNameClassPairCallbackHandler
    extends CollectingNameClassPairCallbackHandler {
        private NameClassPairMapper mapper;

        public MappingCollectingNameClassPairCallbackHandler(NameClassPairMapper mapper) {
            this.mapper = mapper;
        }

        public Object getObjectFromNameClassPair(NameClassPair nameClassPair) {
            try {
                return this.mapper.mapFromNameClassPair(nameClassPair);
            }
            catch (NamingException e) {
                throw LdapTemplate.this.getExceptionTranslator().translate(e);
            }
        }
    }

    private final class NullDirContextProcessor
    implements DirContextProcessor {
        private NullDirContextProcessor() {
        }

        public void postProcess(DirContext ctx) throws NamingException {
        }

        public void preProcess(DirContext ctx) throws NamingException {
        }
    }
}

