/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support.filter;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.ldap.support.filter.AbstractFilter;

public abstract class CompareFilter
extends AbstractFilter {
    private final String attribute;
    private final String value;
    private final String encodedValue;

    public CompareFilter(String attribute, String value) {
        this.attribute = attribute;
        this.value = value;
        this.encodedValue = this.encodeValue(value);
    }

    String getEncodedValue() {
        return this.encodedValue;
    }

    protected String encodeValue(String value) {
        return LdapEncoder.filterEncode(value);
    }

    public CompareFilter(String attribute, int value) {
        this.attribute = attribute;
        this.value = String.valueOf(value);
        this.encodedValue = LdapEncoder.filterEncode(this.value);
    }

    public StringBuffer encode(StringBuffer buff) {
        buff.append('(');
        buff.append(this.attribute).append(this.getCompareString()).append(this.encodedValue);
        buff.append(')');
        return buff;
    }

    public boolean equals(Object o) {
        if (o instanceof CompareFilter && o.getClass() == this.getClass()) {
            CompareFilter that = (CompareFilter)o;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.attribute, (Object)that.attribute);
            builder.append((Object)this.value, (Object)that.value);
            return builder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.attribute);
        builder.append((Object)this.value);
        return builder.toHashCode();
    }

    protected abstract String getCompareString();
}

