/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.AbstractMessageCondition;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class DestinationPatternsMessageCondition
extends AbstractMessageCondition<DestinationPatternsMessageCondition> {
    public static final String LOOKUP_DESTINATION_HEADER = "lookupDestination";
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;

    public DestinationPatternsMessageCondition(String ... patterns) {
        this(patterns, (PathMatcher)null);
    }

    public DestinationPatternsMessageCondition(String[] patterns, @Nullable PathMatcher pathMatcher) {
        this(Arrays.asList(patterns), pathMatcher);
    }

    private DestinationPatternsMessageCondition(Collection<String> patterns, @Nullable PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
        this.patterns = Collections.unmodifiableSet(DestinationPatternsMessageCondition.prependLeadingSlash(patterns, this.pathMatcher));
    }

    private static Set<String> prependLeadingSlash(Collection<String> patterns, PathMatcher pathMatcher) {
        boolean slashSeparator = pathMatcher.combine("a", "a").equals("a/a");
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.size());
        for (String pattern : patterns) {
            if (slashSeparator && StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            result.add(pattern);
        }
        return result;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<String> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public DestinationPatternsMessageCondition combine(DestinationPatternsMessageCondition other) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (String pattern1 : this.patterns) {
                for (String pattern2 : other.patterns) {
                    result.add(this.pathMatcher.combine(pattern1, pattern2));
                }
            }
        } else if (!this.patterns.isEmpty()) {
            result.addAll(this.patterns);
        } else if (!other.patterns.isEmpty()) {
            result.addAll(other.patterns);
        } else {
            result.add("");
        }
        return new DestinationPatternsMessageCondition(result, this.pathMatcher);
    }

    @Override
    public DestinationPatternsMessageCondition getMatchingCondition(Message<?> message) {
        String destination = (String)message.getHeaders().get(LOOKUP_DESTINATION_HEADER);
        if (destination == null) {
            return null;
        }
        if (this.patterns.isEmpty()) {
            return this;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : this.patterns) {
            if (!pattern.equals(destination) && !this.pathMatcher.match(pattern, destination)) continue;
            matches.add(pattern);
        }
        if (matches.isEmpty()) {
            return null;
        }
        Collections.sort(matches, this.pathMatcher.getPatternComparator(destination));
        return new DestinationPatternsMessageCondition(matches, this.pathMatcher);
    }

    @Override
    public int compareTo(DestinationPatternsMessageCondition other, Message<?> message) {
        String destination = (String)message.getHeaders().get(LOOKUP_DESTINATION_HEADER);
        if (destination == null) {
            return 0;
        }
        Comparator patternComparator = this.pathMatcher.getPatternComparator(destination);
        Iterator<String> iterator = this.patterns.iterator();
        Iterator<String> iteratorOther = other.patterns.iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = patternComparator.compare(iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

